/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.network.ISplittableMessage;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHelper;

public class SyncContainerStacksMessage
implements ISplittableMessage {
    private final int windowId;
    private final int stateId;
    private final List<ItemStack> itemStacks;
    private final ItemStack carriedStack;

    public SyncContainerStacksMessage(int windowId, int stateId, List<ItemStack> itemStacks, ItemStack carriedStack) {
        this.windowId = windowId;
        this.stateId = stateId;
        this.itemStacks = itemStacks;
        this.carriedStack = carriedStack;
    }

    public static void encode(SyncContainerStacksMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeByte(msg.windowId);
        packetBuffer.m_130130_(msg.stateId);
        packetBuffer.writeShort(msg.itemStacks.size());
        for (ItemStack itemstack : msg.itemStacks) {
            PacketHelper.writeItemStack(itemstack, packetBuffer);
        }
        packetBuffer.writeItemStack(msg.carriedStack, true);
    }

    public static SyncContainerStacksMessage decode(FriendlyByteBuf packetBuffer) {
        short windowId = packetBuffer.readUnsignedByte();
        int stateId = packetBuffer.m_130242_();
        int slots = packetBuffer.readShort();
        NonNullList itemStacks = NonNullList.m_122780_((int)slots, (Object)ItemStack.f_41583_);
        for (int j = 0; j < slots; ++j) {
            itemStacks.set(j, PacketHelper.readItemStack(packetBuffer));
        }
        ItemStack carriedStack = packetBuffer.m_130267_();
        return new SyncContainerStacksMessage(windowId, stateId, (List<ItemStack>)itemStacks, carriedStack);
    }

    public static void onMessage(SyncContainerStacksMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncContainerStacksMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SyncContainerStacksMessage msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !(player.f_36096_ instanceof StorageContainerMenuBase) || player.f_36096_.f_38840_ != msg.windowId) {
            return;
        }
        player.f_36096_.m_182410_(msg.stateId, msg.itemStacks, msg.carriedStack);
    }
}

