/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.common.IItemActionPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.common.ItemActionHandlerRegistry;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncItemHighlightsMessage;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public record RequestItemHighlightsMessage(ItemStack stack, List<BlockPos> storagePositions, Map<ResourceLocation, Object> extras) {
    public static void encode(RequestItemHighlightsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeItemStack(msg.stack(), false);
        packetBuffer.m_236828_(msg.storagePositions(), FriendlyByteBuf::m_130064_);
        RequestItemHighlightsMessage.encodeExtras(msg.extras(), packetBuffer);
    }

    private static void encodeExtras(Map<ResourceLocation, Object> extras, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(extras.size());
        for (Map.Entry<ResourceLocation, Object> e : extras.entrySet()) {
            ResourceLocation id = e.getKey();
            ItemActionHandlerRegistry.get(id).ifPresent(h -> {
                packetBuffer.m_130085_(id);
                RequestItemHighlightsMessage.encodeWith(h, packetBuffer, e.getValue());
            });
        }
    }

    private static <T> void encodeWith(IItemActionPayloadHandler<T> handler, FriendlyByteBuf packetBuffer, Object v) {
        handler.encode(packetBuffer, v);
    }

    public static RequestItemHighlightsMessage decode(FriendlyByteBuf packetBuffer) {
        return new RequestItemHighlightsMessage(packetBuffer.m_130267_(), packetBuffer.m_236845_(FriendlyByteBuf::m_130135_), RequestItemHighlightsMessage.decodeExtras(packetBuffer));
    }

    private static Map<ResourceLocation, Object> decodeExtras(FriendlyByteBuf packetBuffer) {
        int size = packetBuffer.readInt();
        LinkedHashMap<ResourceLocation, Object> extras = new LinkedHashMap<ResourceLocation, Object>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = packetBuffer.m_130281_();
            ItemActionHandlerRegistry.get(id).ifPresent(h -> extras.put(id, h.decode(packetBuffer)));
        }
        return extras;
    }

    static void onMessage(RequestItemHighlightsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> RequestItemHighlightsMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, RequestItemHighlightsMessage msg) {
        if (player == null) {
            return;
        }
        ItemStackKey stackKey = ItemStackKey.of(msg.stack());
        Level level = player.m_9236_();
        AtomicInteger stackMatchNumber = new AtomicInteger(0);
        AtomicInteger itemMatchNumber = new AtomicInteger(0);
        ArrayList<BlockPos> stackPositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> itemPositions = new ArrayList<BlockPos>();
        msg.storagePositions().forEach(pos -> WorldHelper.getLoadedBlockEntity(level, pos, IControllableStorage.class).ifPresent(storage -> {
            ISlotTracker slotTracker = storage.getStorageWrapper().getInventoryHandler().getSlotTracker();
            if (slotTracker.getPartialStacks().contains(stackKey) || slotTracker.getFullStacks().contains(stackKey)) {
                stackPositions.add((BlockPos)pos);
            } else if (slotTracker.getItems().contains(msg.stack().m_41720_())) {
                itemPositions.add((BlockPos)pos);
            }
        }));
        stackMatchNumber.addAndGet(stackPositions.size());
        itemMatchNumber.addAndGet(itemPositions.size());
        PacketHandler.INSTANCE.sendToClient(player, new SyncItemHighlightsMessage(stackPositions, itemPositions, List.of()));
        msg.extras().forEach((id, extra) -> ItemActionHandlerRegistry.get(id).ifPresent(h -> {
            IItemActionPayloadHandler.HighlightResult result = RequestItemHighlightsMessage.compute(h, player, stackKey, extra);
            stackMatchNumber.addAndGet(result.stackCounts());
            itemMatchNumber.addAndGet(result.itemCounts());
        }));
        MutableComponent message = null;
        if (stackMatchNumber.get() == 0 && itemMatchNumber.get() == 0) {
            message = Component.m_237115_((String)"gui.sophisticatedcore.status.no_matching_items_found");
            player.m_6330_((SoundEvent)SoundEvents.f_12209_.m_203334_(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne(level.f_46441_) * 0.1f);
        } else {
            if (stackMatchNumber.get() > 0) {
                message = Component.m_237110_((String)"gui.sophisticatedcore.status.matching_stacks_found", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(stackMatchNumber.get())).m_130948_(Style.f_131099_.m_178520_(5025616))});
            }
            if (itemMatchNumber.get() > 0) {
                MutableComponent itemMessage = Component.m_237110_((String)"gui.sophisticatedcore.status.matching_items_found", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(itemMatchNumber.get())).m_130948_(Style.f_131099_.m_178520_(4367861))});
                message = message != null ? message.m_6879_().m_130946_(" ").m_7220_((Component)itemMessage) : itemMessage;
            }
            player.m_6330_((SoundEvent)SoundEvents.f_12211_.m_203334_(), SoundSource.PLAYERS, 1.0f, 0.95f + RandHelper.getRandomMinusOneToOne(level.f_46441_) * 0.1f);
        }
        player.m_5661_((Component)message, true);
    }

    private static <T> IItemActionPayloadHandler.HighlightResult compute(IItemActionPayloadHandler<T> handler, ServerPlayer serverPlayer, ItemStackKey stackKey, Object extra) {
        return handler.computeHighlight(serverPlayer, stackKey, extra);
    }
}

