/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.render.ContraptionEntityRenderer;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class CarriageContraptionEntityRenderer
extends ContraptionEntityRenderer<CarriageContraptionEntity> {
    public CarriageContraptionEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public boolean shouldRender(CarriageContraptionEntity entity, Frustum clippingHelper, double cameraX, double cameraY, double cameraZ) {
        Carriage carriage = entity.getCarriage();
        if (carriage != null) {
            for (CarriageBogey bogey : carriage.bogeys) {
                if (bogey == null) continue;
                bogey.couplingAnchors.replace(v -> null);
            }
        }
        return super.shouldRender(entity, clippingHelper, cameraX, cameraY, cameraZ);
    }

    @Override
    public void render(CarriageContraptionEntity entity, float yaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int overlay) {
        if (!entity.validForRender || entity.firstPositionUpdate) {
            return;
        }
        super.render(entity, yaw, partialTicks, ms, buffers, overlay);
        Carriage carriage = entity.getCarriage();
        if (carriage == null) {
            return;
        }
        Vec3 position = entity.m_20318_(partialTicks);
        float viewYRot = entity.m_5675_(partialTicks);
        float viewXRot = entity.m_5686_(partialTicks);
        int bogeySpacing = carriage.bogeySpacing;
        carriage.bogeys.forEach(bogey -> {
            BlockPos bogeyPos;
            if (bogey == null) {
                return;
            }
            BlockPos blockPos = bogeyPos = bogey.isLeading ? BlockPos.f_121853_ : BlockPos.f_121853_.m_5484_(entity.getInitialOrientation().m_122428_(), bogeySpacing);
            if (!VisualizationManager.supportsVisualization((LevelAccessor)entity.m_9236_()) && !entity.getContraption().isHiddenInPortal(bogeyPos)) {
                ms.m_85836_();
                CarriageContraptionEntityRenderer.translateBogey(ms, bogey, bogeySpacing, viewYRot, viewXRot, partialTicks);
                int light = CarriageContraptionEntityRenderer.getBogeyLightCoords(entity, bogey, partialTicks);
                bogey.getStyle().render(bogey.getSize(), partialTicks, ms, buffers, light, overlay, bogey.wheelAngle.getValue(partialTicks), bogey.bogeyData, true);
                ms.m_85849_();
            }
            bogey.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, partialTicks, bogey.isLeading);
            if (!carriage.isOnTwoBogeys()) {
                bogey.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, partialTicks, !bogey.isLeading);
            }
        });
    }

    public static void translateBogey(PoseStack ms, CarriageBogey bogey, int bogeySpacing, float viewYRot, float viewXRot, float partialTicks) {
        boolean selfUpsideDown = bogey.isUpsideDown();
        boolean leadingUpsideDown = bogey.carriage.leadingBogey().isUpsideDown();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(viewYRot + 90.0f)).rotateXDegrees(-viewXRot)).rotateYDegrees(180.0f)).translate(0.0f, 0.0f, bogey.isLeading ? 0.0f : (float)(-bogeySpacing)).rotateYDegrees(-180.0f)).rotateXDegrees(viewXRot)).rotateYDegrees(-viewYRot - 90.0f)).rotateYDegrees(bogey.yaw.getValue(partialTicks))).rotateXDegrees(bogey.pitch.getValue(partialTicks))).translate(0.0f, 0.5f, 0.0f).rotateZDegrees(selfUpsideDown ? 180.0f : 0.0f)).translateY(selfUpsideDown != leadingUpsideDown ? 2.0f : 0.0f);
    }

    public static int getBogeyLightCoords(CarriageContraptionEntity entity, CarriageBogey bogey, float partialTicks) {
        Vec3 anchorPosition = bogey.getAnchorPosition();
        BlockPos lightPos = BlockPos.m_274446_((Position)(anchorPosition == null ? entity.m_7371_(partialTicks) : anchorPosition));
        return LightTexture.m_109885_((int)entity.m_9236_().m_45517_(LightLayer.BLOCK, lightPos), (int)entity.m_9236_().m_45517_(LightLayer.SKY, lightPos));
    }
}

