/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wildfire.main.config.FloatConfigKey;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class WildfireSlider
extends AbstractSliderButton {
    private final double minValue;
    private final double maxValue;
    private final FloatConsumer valueUpdate;
    private final Float2ObjectFunction<Component> messageUpdate;
    private final FloatConsumer onSave;
    private float lastValue;
    private boolean changed;

    public WildfireSlider(int xPos, int yPos, int width, int height, FloatConfigKey config, double currentVal, FloatConsumer valueUpdate, Float2ObjectFunction<Component> messageUpdate, FloatConsumer onSave) {
        this(xPos, yPos, width, height, config.getMinInclusive(), config.getMaxInclusive(), currentVal, valueUpdate, messageUpdate, onSave);
    }

    public WildfireSlider(int xPos, int yPos, int width, int height, double minVal, double maxVal, double currentVal, FloatConsumer valueUpdate, Float2ObjectFunction<Component> messageUpdate, FloatConsumer onSave) {
        super(xPos, yPos, width, height, (Component)Component.m_237119_(), 0.0);
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.valueUpdate = valueUpdate;
        this.messageUpdate = messageUpdate;
        this.onSave = onSave;
        this.setValueInternal(currentVal);
    }

    protected void m_5695_() {
        this.m_93666_((Component)this.messageUpdate.get(this.lastValue));
    }

    protected void m_5697_() {
        float newValue = this.getFloatValue();
        if (this.lastValue != newValue) {
            this.valueUpdate.accept(newValue);
            this.lastValue = newValue;
            this.changed = true;
        }
    }

    public void save() {
        if (this.changed) {
            this.onSave.accept(this.lastValue);
            this.changed = false;
        }
    }

    public void m_7691_(double mouseX, double mouseY) {
        this.save();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean result = super.m_7933_(keyCode, scanCode, modifiers);
        if (keyCode == 263 || keyCode == 262) {
            this.save();
        }
        return result;
    }

    public void m_87963_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.disableDepthTest();
        graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), 0x54000000);
        graphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.m_5711_() - 1, this.m_252907_() + this.m_93694_() - 1, -2145246686);
        int xPos = this.m_252754_() + 2 + (int)(this.f_93577_ * (double)(this.m_5711_() - 3));
        graphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1, xPos - 1, this.m_252907_() + this.m_93694_() - 1, -1272831386);
        int xPos2 = this.m_252754_() + 3 + (int)(this.f_93577_ * (double)(this.m_5711_() - 4));
        graphics.m_280509_(xPos2 - 2, this.m_252907_() + 1, xPos2, this.m_252907_() + this.m_93694_() - 1, 0x78FFFFFF);
        RenderSystem.enableDepthTest();
        Font font = Minecraft.m_91087_().f_91062_;
        this.m_280372_(graphics, font, 2, this.f_93622_ || this.changed ? 0xFFFF55 : 0xFFFFFF);
    }

    public float getFloatValue() {
        return (float)this.getValue();
    }

    public double getValue() {
        return this.f_93577_ * (this.maxValue - this.minValue) + this.minValue;
    }

    private void setValueInternal(double value) {
        this.f_93577_ = Mth.m_14008_((double)((value - this.minValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
        this.lastValue = (float)value;
        this.m_5695_();
    }
}

