/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.utils.mixedbeer;

import java.util.ArrayList;
import java.util.List;
import lekavar.lma.drinkbeer.utils.beer.Beers;
import lekavar.lma.drinkbeer.utils.mixedbeer.Flavors;
import lekavar.lma.drinkbeer.utils.mixedbeer.Spices;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.tuple.Pair;

public class MixedBeerOnUsing {
    private Beers beer = null;
    private int hunger = 0;
    private float health = 0.0f;
    private int drunkValue = 1;
    private List<Spices> spiceList = new ArrayList<Spices>();
    private List<Flavors> flavorList = new ArrayList<Flavors>();
    List<Pair<MobEffect, Integer>> statusEffectList = new ArrayList<Pair<MobEffect, Integer>>();
    List<Flavors> actionList = new ArrayList<Flavors>();

    public Item getBeerItem() {
        return this.beer == null ? Beers.DEFAULT_BEER.getBeerItem() : this.beer.getBeerItem();
    }

    public Beers getBeer() {
        return this.beer;
    }

    public int getDrunkValue() {
        return this.drunkValue;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getHealth() {
        return this.health;
    }

    public List<Spices> getSpiceList() {
        return this.spiceList;
    }

    public List<Flavors> getFlavorList() {
        return this.flavorList;
    }

    public List<Pair<MobEffect, Integer>> getStatusEffectList() {
        return this.statusEffectList;
    }

    public List<Flavors> getActionList() {
        return this.actionList;
    }

    public void setBeer(Beers beer) {
        this.beer = beer;
    }

    private void setHunger(int hunger) {
        this.hunger = hunger;
    }

    public void addHunger(int hunger) {
        this.setHunger(this.hunger + hunger);
    }

    private void setHealth(float health) {
        this.health = health;
    }

    public void addHealth(float health) {
        this.setHealth(this.health + health);
    }

    public void setSpiceList(List<Integer> spiceList) {
        for (int spiceId : spiceList) {
            Spices spice = Spices.byId(spiceId);
            this.spiceList.add(spice);
            this.flavorList.add(spice.getFlavor());
        }
    }

    private void setDrunkValue(int drunkValue) {
        this.drunkValue = drunkValue;
    }

    public void addDrunkValue(int drunkValue) {
        this.setDrunkValue(this.drunkValue + drunkValue);
    }

    public void addFlavor(Flavors flavor) {
        this.flavorList.add(flavor);
    }

    public void addAction(Flavors flavor) {
        this.actionList.add(flavor);
    }

    public void addStatusEffect(List<Pair<MobEffect, Integer>> newStatusEffectList) {
        for (Pair<MobEffect, Integer> newStatusEffect : newStatusEffectList) {
            this.addSpecificStatusEffectDuration((MobEffect)newStatusEffect.getKey(), (Integer)newStatusEffect.getValue());
        }
    }

    public void addSpecificStatusEffectDuration(MobEffect targetStatusEffect, int duration) {
        if (!this.statusEffectList.isEmpty()) {
            for (int i = 0; i < this.statusEffectList.size(); ++i) {
                Pair<MobEffect, Integer> statusEffect = this.statusEffectList.get(i);
                if (!((MobEffect)statusEffect.getKey()).equals(targetStatusEffect)) continue;
                int newDuratin = (Integer)statusEffect.getValue() + duration;
                this.statusEffectList.set(i, (Pair<MobEffect, Integer>)Pair.of((Object)((MobEffect)statusEffect.getKey()), (Object)newDuratin));
                return;
            }
        }
        Pair statusEffect = Pair.of((Object)targetStatusEffect, (Object)duration);
        this.statusEffectList.add((Pair<MobEffect, Integer>)statusEffect);
    }

    public void addAllStatusEffectDuration(int duration) {
        if (!this.statusEffectList.isEmpty()) {
            for (int i = 0; i < this.statusEffectList.size(); ++i) {
                Pair<MobEffect, Integer> statusEffect = this.statusEffectList.get(i);
                int newDuratin = (Integer)statusEffect.getValue() + duration;
                this.statusEffectList.set(i, (Pair<MobEffect, Integer>)Pair.of((Object)((MobEffect)statusEffect.getKey()), (Object)newDuratin));
            }
        }
    }

    public boolean multiplySpecificStatusEffectDuration(MobEffect targetStatusEffect, float multiplyValue) {
        if (!this.statusEffectList.isEmpty()) {
            for (int i = 0; i < this.statusEffectList.size(); ++i) {
                Pair<MobEffect, Integer> statusEffect = this.statusEffectList.get(i);
                if (!((MobEffect)statusEffect.getKey()).equals(targetStatusEffect)) continue;
                int newDuration = (int)((float)((Integer)statusEffect.getValue()).intValue() * multiplyValue);
                this.statusEffectList.set(i, (Pair<MobEffect, Integer>)Pair.of((Object)((MobEffect)statusEffect.getKey()), (Object)newDuration));
                return true;
            }
        }
        return false;
    }

    public void multiplyAllStatusEffectDuration(float multiplyValue) {
        if (!this.statusEffectList.isEmpty()) {
            for (int i = 0; i < this.statusEffectList.size(); ++i) {
                Pair<MobEffect, Integer> statusEffect = this.statusEffectList.get(i);
                int newDuration = (int)((float)((Integer)statusEffect.getValue()).intValue() * multiplyValue);
                this.statusEffectList.set(i, (Pair<MobEffect, Integer>)Pair.of((Object)((MobEffect)statusEffect.getKey()), (Object)newDuration));
            }
        }
    }
}

