/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.udp.bothbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.Arrays;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.PacketUdpHandler;

public class CustomPacket
implements Packet<PacketUdpHandler> {
    private String addonId;
    private byte[] payload;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.addonId = in.readUTF();
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        Preconditions.checkNotNull((Object)this.addonId, (Object)"addonId cannot be null");
        Preconditions.checkNotNull((Object)this.payload, (Object)"payload cannot be null");
        out.writeUTF(this.addonId);
        out.writeInt(this.payload.length);
        out.write(this.payload);
    }

    @Override
    public void handle(PacketUdpHandler handler) {
        handler.handle(this);
    }

    public CustomPacket() {
    }

    public CustomPacket(String addonId, byte[] payload) {
        this.addonId = addonId;
        this.payload = payload;
    }

    public String toString() {
        return "CustomPacket(addonId=" + this.getAddonId() + ", payload=" + Arrays.toString(this.getPayload()) + ")";
    }

    public String getAddonId() {
        return this.addonId;
    }

    public byte[] getPayload() {
        return this.payload;
    }
}

