/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.audio.capture;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.packets.PacketSerializable;

public final class CaptureInfo
implements PacketSerializable {
    private int sampleRate;
    private int mtuSize;
    private CodecInfo encoderInfo;

    @Override
    public void deserialize(ByteArrayDataInput in) {
        this.sampleRate = in.readInt();
        this.mtuSize = in.readInt();
        if (in.readBoolean()) {
            this.encoderInfo = new CodecInfo();
            this.encoderInfo.deserialize(in);
        }
    }

    @Override
    public void serialize(ByteArrayDataOutput out) {
        out.writeInt(this.sampleRate);
        out.writeInt(this.mtuSize);
        out.writeBoolean(this.encoderInfo != null);
        if (this.encoderInfo != null) {
            this.encoderInfo.serialize(out);
        }
    }

    public CaptureInfo(int sampleRate, int mtuSize, CodecInfo encoderInfo) {
        this.sampleRate = sampleRate;
        this.mtuSize = mtuSize;
        this.encoderInfo = encoderInfo;
    }

    public CaptureInfo() {
    }

    public String toString() {
        return "CaptureInfo(sampleRate=" + this.getSampleRate() + ", mtuSize=" + this.getMtuSize() + ", encoderInfo=" + this.getEncoderInfo() + ")";
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getMtuSize() {
        return this.mtuSize;
    }

    public CodecInfo getEncoderInfo() {
        return this.encoderInfo;
    }
}

