/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.Inputs;
import su.plo.lib.mod.client.gui.screen.GuiScreen;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.client.ModVoiceClient;

public final class ScreenWrapper
extends Screen {
    private final GuiScreen screen;
    private boolean ignoreFirstMove = true;
    @Nullable
    private GuiGraphics currentContext;
    private int lastMouseX;
    private int lastMouseY;
    private float lastPartialTicks;

    public static void openScreen(@Nullable GuiScreen screen) {
        ScreenWrapper wrapped;
        if (screen == null) {
            Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_(null));
            return;
        }
        wrapped.screen.screen = wrapped = new ScreenWrapper(screen);
        Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_((Screen)wrapped));
    }

    public static Optional<ScreenWrapper> getCurrentWrappedScreen() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ScreenWrapper) {
            return Optional.of((ScreenWrapper)screen);
        }
        return Optional.empty();
    }

    private ScreenWrapper(@NotNull GuiScreen screen) {
        super(RenderUtil.getTextConverter().convert(screen.getTitle()));
        this.screen = screen;
    }

    @NotNull
    public Component m_96636_() {
        if (this.screen == null) {
            return super.m_96636_();
        }
        return RenderUtil.getTextConverter().convert(this.screen.getTitle());
    }

    public void m_86600_() {
        this.screen.tick();
    }

    protected void m_7856_() {
        this.screen.init();
        ModVoiceClient.INSTANCE.getEventBus().unregister((Object)ModVoiceClient.INSTANCE, (Object)this);
        ModVoiceClient.INSTANCE.getEventBus().register(ModVoiceClient.INSTANCE, (Object)this);
    }

    public void m_7861_() {
        ModVoiceClient.INSTANCE.getEventBus().unregister((Object)ModVoiceClient.INSTANCE, (Object)this);
        this.screen.removed();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderUtil.preserveGlState();
        this.currentContext = guiGraphics;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.lastPartialTicks = partialTicks;
        GuiRenderContext context = new GuiRenderContext(guiGraphics);
        this.screen.render(context, mouseX, mouseY, partialTicks);
        this.currentContext = null;
        RenderUtil.restoreGlState();
    }

    public void renderBackground(@NotNull GuiRenderContext context) {
        if (this.currentContext == null) {
            return;
        }
        super.m_280273_(this.currentContext);
        RenderUtil.restoreGlState(true);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.screen.mouseClicked(mouseX, mouseY, mouseButton);
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.screen.mouseReleased(mouseX, mouseY, button);
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.screen.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.screen.mouseScrolled(mouseX, mouseY, delta);
        return false;
    }

    public boolean m_5534_(char typedChar, int modifiers) {
        return this.screen.charTyped(typedChar, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.innerKeyPressed(keyCode, scanCode, modifiers);
    }

    private boolean innerKeyPressed(int keyCode, int scanCode, int modifiers) {
        boolean shiftKeyDown;
        if (keyCode == 0) {
            return false;
        }
        if (this.screen.keyPressed(keyCode, modifiers)) {
            return true;
        }
        if (this.m_6913_() && keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (keyCode == 258 && !this.screen.changeFocus(shiftKeyDown = Inputs.hasShiftDown())) {
            this.screen.changeFocus(shiftKeyDown);
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.screen.keyReleased(keyCode, '\u0000', modifiers)) {
            return false;
        }
        super.m_7920_(keyCode, 0, modifiers);
        return false;
    }

    public boolean m_6913_() {
        return this.screen.shouldCloseOnEsc();
    }

    public void m_7379_() {
        Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91152_(null));
    }

    public void renderTooltipWrapped(@NotNull GuiRenderContext context, @NotNull List<McTextComponent> tooltip, int mouseX, int mouseY) {
        this.m_257959_(Language.m_128107_().m_128112_(new ArrayList(RenderUtil.getTextConverter().convert(tooltip))));
    }

    public String toString() {
        return "ScreenWrapper(screen=" + String.valueOf(this.getScreen()) + ", ignoreFirstMove=" + this.ignoreFirstMove + ", currentContext=" + String.valueOf(this.currentContext) + ", lastMouseX=" + this.lastMouseX + ", lastMouseY=" + this.lastMouseY + ", lastPartialTicks=" + this.lastPartialTicks + ")";
    }

    public GuiScreen getScreen() {
        return this.screen;
    }
}

