/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_3532;

public final class QuadUtil {
    public static void interpolate(MutableQuadView quad, class_1058 oldSprite, class_1058 newSprite) {
        float oldMinU = oldSprite.method_4594();
        float oldMinV = oldSprite.method_4593();
        float newMinU = newSprite.method_4594();
        float newMinV = newSprite.method_4593();
        float uFactor = (newSprite.method_4577() - newMinU) / (oldSprite.method_4577() - oldMinU);
        float vFactor = (newSprite.method_4575() - newMinV) / (oldSprite.method_4575() - oldMinV);
        for (int i = 0; i < 4; ++i) {
            quad.uv(i, newMinU + (quad.u(i) - oldMinU) * uFactor, newMinV + (quad.v(i) - oldMinV) * vFactor);
        }
    }

    public static void assignLerpedUVs(MutableQuadView quad, class_1058 sprite) {
        float delta = sprite.method_23842();
        float centerU = (sprite.method_4594() + sprite.method_4577()) * 0.5f;
        float centerV = (sprite.method_4593() + sprite.method_4575()) * 0.5f;
        float lerpedMinU = class_3532.method_16439((float)delta, (float)sprite.method_4594(), (float)centerU);
        float lerpedMaxU = class_3532.method_16439((float)delta, (float)sprite.method_4577(), (float)centerU);
        float lerpedMinV = class_3532.method_16439((float)delta, (float)sprite.method_4593(), (float)centerV);
        float lerpedMaxV = class_3532.method_16439((float)delta, (float)sprite.method_4575(), (float)centerV);
        quad.uv(0, lerpedMinU, lerpedMinV);
        quad.uv(1, lerpedMinU, lerpedMaxV);
        quad.uv(2, lerpedMaxU, lerpedMaxV);
        quad.uv(3, lerpedMaxU, lerpedMinV);
    }

    public static void emitOverlayQuad(QuadEmitter emitter, class_2350 face, class_1058 sprite, int color, RenderMaterial material) {
        emitter.square(face, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        emitter.color(color, color, color, color);
        QuadUtil.assignLerpedUVs((MutableQuadView)emitter, sprite);
        emitter.material(material);
        emitter.emit();
    }

    public static boolean isQuadUnitSquare(QuadView quad) {
        int indexB;
        int indexA;
        switch (quad.lightFace().method_10166()) {
            case field_11048: {
                indexA = 1;
                indexB = 2;
                break;
            }
            case field_11052: {
                indexA = 0;
                indexB = 2;
                break;
            }
            case field_11051: {
                indexA = 1;
                indexB = 0;
                break;
            }
            default: {
                return false;
            }
        }
        for (int i = 0; i < 4; ++i) {
            float a = quad.posByIndex(i, indexA);
            if ((a >= 1.0E-4f || a <= -1.0E-4f) && (a >= 1.0001f || a <= 0.9999f)) {
                return false;
            }
            float b = quad.posByIndex(i, indexB);
            if (!(b >= 1.0E-4f) && !(b <= -1.0E-4f) || !(b >= 1.0001f) && !(b <= 0.9999f)) continue;
            return false;
        }
        return true;
    }

    public static int getTextureOrientation(QuadView quad) {
        int rotation = QuadUtil.getUVRotation(quad);
        if (QuadUtil.getUVWinding(quad) == Winding.CLOCKWISE) {
            return rotation + 4;
        }
        return rotation;
    }

    public static int getUVRotation(QuadView quad) {
        int minVertex = 0;
        float minDistance = 3.0f;
        for (int vertexId = 0; vertexId < 4; ++vertexId) {
            float v;
            float u = quad.u(vertexId);
            float distance = u * u + (v = quad.v(vertexId)) * v;
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minVertex = vertexId;
        }
        return minVertex;
    }

    public static Winding getUVWinding(QuadView quad) {
        float u3 = quad.u(3);
        float v3 = quad.v(3);
        float u0 = quad.u(0);
        float v0 = quad.v(0);
        float u1 = quad.u(1);
        float v1 = quad.v(1);
        float value = (u3 - u0) * (v1 - v0) - (v3 - v0) * (u1 - u0);
        if (value > 0.0f) {
            return Winding.COUNTERCLOCKWISE;
        }
        if (value < 0.0f) {
            return Winding.CLOCKWISE;
        }
        return Winding.UNDEFINED;
    }

    public static enum Winding {
        COUNTERCLOCKWISE,
        CLOCKWISE,
        UNDEFINED;


        public Winding reverse() {
            if (this == UNDEFINED) {
                return this;
            }
            return this == CLOCKWISE ? COUNTERCLOCKWISE : CLOCKWISE;
        }
    }
}

