/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.network.ISplittableMessage;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;

public class SyncPlayerSettingsMessage
implements ISplittableMessage {
    private final String playerTagName;
    @Nullable
    private final CompoundTag settingsNbt;

    public SyncPlayerSettingsMessage(String playerTagName, @Nullable CompoundTag settingsNbt) {
        this.playerTagName = playerTagName;
        this.settingsNbt = settingsNbt;
    }

    public static void encode(SyncPlayerSettingsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130070_(msg.playerTagName);
        packetBuffer.m_130079_(msg.settingsNbt);
    }

    public static SyncPlayerSettingsMessage decode(FriendlyByteBuf packetBuffer) {
        return new SyncPlayerSettingsMessage(packetBuffer.m_130277_(), packetBuffer.m_130261_());
    }

    public static void onMessage(SyncPlayerSettingsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncPlayerSettingsMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SyncPlayerSettingsMessage msg) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null || msg.settingsNbt == null) {
            return;
        }
        BiConsumer<Player, CompoundTag> setSettings = (player, settingsNbt) -> SettingsManager.setPlayerSettingsTag(player, msg.playerTagName, settingsNbt);
        setSettings.accept((Player)localPlayer, msg.settingsNbt);
    }
}

