/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.p3pp3rf1y.sophisticatedcore.network.DepositItemsMessage;
import net.p3pp3rf1y.sophisticatedcore.network.ISplittableMessage;
import net.p3pp3rf1y.sophisticatedcore.network.PacketSplitter;
import net.p3pp3rf1y.sophisticatedcore.network.RequestItemHighlightsMessage;
import net.p3pp3rf1y.sophisticatedcore.network.RestockItemsMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SplitPacket;
import net.p3pp3rf1y.sophisticatedcore.network.SyncAdditionalSlotInfoMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerClientDataMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerStacksMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncDatapackSettingsTemplateMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncEmptySlotIconsMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncItemHighlightsMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncItemTransfersMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncPlayerSettingsMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncSlotChangeErrorMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncSlotStackMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncTemplateSettingsMessage;
import net.p3pp3rf1y.sophisticatedcore.network.TransferFullSlotMessage;
import net.p3pp3rf1y.sophisticatedcore.network.TransferItemsMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.PlayDiscMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.SoundFinishedNotificationMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StopDiscPlaybackMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankClickMessage;

public class PacketHandler {
    private static final int PAYLOAD_TO_CLIENT_MAX = 0x100000;
    private static final int PART_SIZE = 1048570;
    private final Map<Class<?>, MessageType<?>> byType = new HashMap();
    private final Map<Integer, MessageType<?>> byId = new HashMap();
    public static final PacketHandler INSTANCE = new PacketHandler("sophisticatedcore");
    private static final String PROTOCOL = "1";
    private final SimpleChannel networkWrapper;
    private int idx = 0;
    private final PacketSplitter splitter = new PacketSplitter(1048570);

    protected PacketHandler(String modId) {
        this.networkWrapper = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modId, "channel"), () -> PROTOCOL, PROTOCOL::equals, PROTOCOL::equals);
    }

    public final void init() {
        this.registerSplitPacket();
        this.registerMessages();
    }

    public void registerSplitPacket() {
        this.registerMessage(SplitPacket.class, SplitPacket::encode, SplitPacket::decode, this::handleSplitPacket);
    }

    public void registerMessages() {
        this.registerMessage(SyncContainerClientDataMessage.class, SyncContainerClientDataMessage::encode, SyncContainerClientDataMessage::decode, SyncContainerClientDataMessage::onMessage);
        this.registerMessage(TransferFullSlotMessage.class, TransferFullSlotMessage::encode, TransferFullSlotMessage::decode, TransferFullSlotMessage::onMessage);
        this.registerMessage(SyncContainerStacksMessage.class, SyncContainerStacksMessage::encode, SyncContainerStacksMessage::decode, SyncContainerStacksMessage::onMessage);
        this.registerMessage(SyncSlotStackMessage.class, SyncSlotStackMessage::encode, SyncSlotStackMessage::decode, SyncSlotStackMessage::onMessage);
        this.registerMessage(SyncPlayerSettingsMessage.class, SyncPlayerSettingsMessage::encode, SyncPlayerSettingsMessage::decode, SyncPlayerSettingsMessage::onMessage);
        this.registerMessage(PlayDiscMessage.class, PlayDiscMessage::encode, PlayDiscMessage::decode, PlayDiscMessage::onMessage);
        this.registerMessage(StopDiscPlaybackMessage.class, StopDiscPlaybackMessage::encode, StopDiscPlaybackMessage::decode, StopDiscPlaybackMessage::onMessage);
        this.registerMessage(SoundFinishedNotificationMessage.class, SoundFinishedNotificationMessage::encode, SoundFinishedNotificationMessage::decode, SoundFinishedNotificationMessage::onMessage);
        this.registerMessage(TankClickMessage.class, TankClickMessage::encode, TankClickMessage::decode, TankClickMessage::onMessage);
        this.registerMessage(SyncTemplateSettingsMessage.class, SyncTemplateSettingsMessage::encode, SyncTemplateSettingsMessage::decode, SyncTemplateSettingsMessage::onMessage);
        this.registerMessage(SyncAdditionalSlotInfoMessage.class, SyncAdditionalSlotInfoMessage::encode, SyncAdditionalSlotInfoMessage::decode, SyncAdditionalSlotInfoMessage::onMessage);
        this.registerMessage(SyncEmptySlotIconsMessage.class, SyncEmptySlotIconsMessage::encode, SyncEmptySlotIconsMessage::decode, SyncEmptySlotIconsMessage::onMessage);
        this.registerMessage(SyncSlotChangeErrorMessage.class, SyncSlotChangeErrorMessage::encode, SyncSlotChangeErrorMessage::decode, SyncSlotChangeErrorMessage::onMessage);
        this.registerMessage(SyncDatapackSettingsTemplateMessage.class, SyncDatapackSettingsTemplateMessage::encode, SyncDatapackSettingsTemplateMessage::decode, SyncDatapackSettingsTemplateMessage::onMessage);
        this.registerMessage(TransferItemsMessage.class, TransferItemsMessage::encode, TransferItemsMessage::decode, TransferItemsMessage::onMessage);
        this.registerMessage(RequestItemHighlightsMessage.class, RequestItemHighlightsMessage::encode, RequestItemHighlightsMessage::decode, RequestItemHighlightsMessage::onMessage);
        this.registerMessage(SyncItemHighlightsMessage.class, SyncItemHighlightsMessage::encode, SyncItemHighlightsMessage::decode, SyncItemHighlightsMessage::onMessage);
        this.registerMessage(DepositItemsMessage.class, DepositItemsMessage::encode, DepositItemsMessage::decode, DepositItemsMessage::onMessage);
        this.registerMessage(SyncItemTransfersMessage.class, SyncItemTransfersMessage::encode, SyncItemTransfersMessage::decode, SyncItemTransfersMessage::onMessage);
        this.registerMessage(RestockItemsMessage.class, RestockItemsMessage::encode, RestockItemsMessage::decode, RestockItemsMessage::onMessage);
    }

    public <M> void registerMessage(Class<M> messageType, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, Supplier<NetworkEvent.Context>> handler) {
        int id = this.idx++;
        MessageType<M> entry = new MessageType<M>(id, messageType, encoder, decoder, handler);
        this.byType.put(messageType, entry);
        this.byId.put(id, entry);
        this.networkWrapper.registerMessage(id, messageType, encoder, decoder, handler);
    }

    public <M> void sendToServer(M message) {
        this.networkWrapper.sendToServer(message);
    }

    public <M> void sendToClient(ServerPlayer player, M message) {
        this.sendPossiblySplit(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public <M> void sendToAllTracking(M message, Entity entity) {
        this.sendPossiblySplit(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public <M> void sentToAllTrackingChunkOf(Level level, BlockPos pos, M message) {
        this.sendPossiblySplit(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), message);
    }

    private <M> void sendPossiblySplit(PacketDistributor.PacketTarget target, M message) {
        if (!(message instanceof ISplittableMessage)) {
            this.networkWrapper.send(target, message);
            return;
        }
        if (target.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            this.networkWrapper.send(target, message);
            return;
        }
        MessageType<M> messageType = this.typeFor(message);
        byte[] fullStream = PacketHandler.encodeVirtualStream(messageType.id, messageType::encodeTo, message);
        if (fullStream.length <= 1048570) {
            this.networkWrapper.send(target, message);
            return;
        }
        this.splitter.splitAndSend(fullStream, payloadSlice -> this.networkWrapper.send(target, (Object)new SplitPacket((byte[])payloadSlice)));
    }

    private <M> MessageType<M> typeFor(M message) {
        MessageType<?> mt = this.byType.get(message.getClass());
        if (mt == null) {
            throw new IllegalStateException("Unregistered message type: " + message.getClass().getName());
        }
        return mt;
    }

    public <M> void sendToAllNear(ResourceKey<Level> dimension, Vec3 position, int range, M message) {
        this.sendPossiblySplit(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(position.f_82479_, position.f_82480_, position.f_82481_, (double)range, dimension)), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <M> byte[] encodeVirtualStream(int msgId, BiConsumer<M, FriendlyByteBuf> encoder, M message) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        try {
            buf.m_130130_(msgId);
            encoder.accept(message, buf);
            byte[] out = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), out);
            byte[] byArray = out;
            return byArray;
        }
        finally {
            buf.release();
        }
    }

    private void handleSplitPacket(SplitPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            FriendlyByteBuf full = this.splitter.acceptPart(msg.payload());
            if (full == null) {
                return;
            }
            try {
                int originalId = full.m_130242_();
                MessageType<?> messageType = this.byId.get(originalId);
                if (messageType == null) {
                    return;
                }
                messageType.decodeAndHandle(full, contextSupplier);
            }
            finally {
                full.release();
            }
        });
        context.setPacketHandled(true);
    }

    private record MessageType<M>(int id, Class<M> type, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, Supplier<NetworkEvent.Context>> handler) {
        public void decodeAndHandle(FriendlyByteBuf buf, Supplier<NetworkEvent.Context> ctx) {
            M msg = this.decoder.apply(buf);
            this.handler.accept(msg, ctx);
        }

        void encodeTo(M msg, FriendlyByteBuf buf) {
            this.encoder.accept(msg, buf);
        }
    }
}

