/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.managers;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lekavar.lma.drinkbeer.effects.DrunkStatusEffect;
import lekavar.lma.drinkbeer.effects.NightHowlStatusEffect;
import lekavar.lma.drinkbeer.entities.damages.AlcoholDamage;
import lekavar.lma.drinkbeer.items.MixedBeerBlockItem;
import lekavar.lma.drinkbeer.managers.SpiceAndFlavorManager;
import lekavar.lma.drinkbeer.registries.ItemRegistry;
import lekavar.lma.drinkbeer.utils.beer.Beers;
import lekavar.lma.drinkbeer.utils.mixedbeer.Flavors;
import lekavar.lma.drinkbeer.utils.mixedbeer.MixedBeerOnUsing;
import lekavar.lma.drinkbeer.utils.mixedbeer.Spices;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MixedBeerManager {
    public static final int MAX_SPICES_COUNT = 3;

    public static ItemStack genMixedBeerItemStack(int beerId, int ... spiceIds) {
        ArrayList<Integer> spiceList = new ArrayList<Integer>();
        for (int spiceId : spiceIds) {
            spiceList.add(spiceId);
        }
        return MixedBeerManager.genMixedBeerItemStack(beerId, spiceList);
    }

    public static ItemStack genMixedBeerItemStack(int beerId, List<Integer> spiceList) {
        ItemStack resultStack = new ItemStack((ItemLike)ItemRegistry.MIXED_BEER.get(), 1);
        spiceList = MixedBeerManager.removeIllegalSpiceId(spiceList);
        CompoundTag tags = resultStack.m_41698_("BlockEntityTag");
        CompoundTag tag = new CompoundTag();
        tags.m_128365_("MixedBeer", (Tag)tag);
        tag.m_128405_("beerId", beerId);
        tag.m_128408_("spiceList", spiceList);
        return resultStack;
    }

    private static List<Integer> removeIllegalSpiceId(List<Integer> spiceList) {
        return spiceList.stream().filter(value -> value.compareTo(0) > 0 && value.compareTo(Spices.size()) <= 0).collect(Collectors.toList());
    }

    public static int getBeerId(ItemStack itemStack) {
        CompoundTag tags;
        int beerId = 0;
        if (itemStack.m_41720_() instanceof MixedBeerBlockItem && (tags = itemStack.m_41737_("BlockEntityTag")) != null && tags.m_128441_("MixedBeer")) {
            beerId = tags.m_128469_("MixedBeer").m_128451_("beerId");
        }
        return beerId;
    }

    public static List<Integer> getSpiceList(ItemStack itemStack) {
        ArrayList<Integer> spiceList = new ArrayList<Integer>();
        CompoundTag tags = itemStack.m_41737_("BlockEntityTag");
        if (tags != null && tags.m_128441_("MixedBeer")) {
            for (int spice : tags.m_128469_("MixedBeer").m_128465_("spiceList")) {
                spiceList.add(spice);
            }
        }
        return spiceList;
    }

    public static String getMixedBeerTranslationKey() {
        return ((Item)ItemRegistry.MIXED_BEER.get()).m_5456_().toString();
    }

    public static String getBaseBeerToolTipTranslationKey() {
        return "item.drinkbeer.mixed_beer.tooltip_base";
    }

    public static String getUnmixedToolTipTranslationKey() {
        return "item.drinkbeer.mixed_beer.tooltip_unmixed";
    }

    public static void useMixedBeer(ItemStack stack, Level world, LivingEntity user) {
        MixedBeerOnUsing mixedBeerOnUsing = new MixedBeerOnUsing();
        mixedBeerOnUsing.setBeer(Beers.byId(MixedBeerManager.getBeerId(stack)));
        mixedBeerOnUsing.addHunger(Objects.requireNonNull(mixedBeerOnUsing.getBeerItem().m_41473_().m_38744_()));
        List<Integer> spiceList = MixedBeerManager.getSpiceList(stack);
        mixedBeerOnUsing.setSpiceList(spiceList);
        Flavors combinedFlavor = SpiceAndFlavorManager.getCombinedFlavor(spiceList);
        if (combinedFlavor != null) {
            mixedBeerOnUsing.addFlavor(combinedFlavor);
        }
        mixedBeerOnUsing.addStatusEffect(MixedBeerManager.getBeerStatusEffectList(mixedBeerOnUsing.getBeerItem(), world));
        SpiceAndFlavorManager.applyFlavorValue(mixedBeerOnUsing);
        DrunkStatusEffect.addStatusEffect(user, mixedBeerOnUsing.getDrunkValue());
        if (mixedBeerOnUsing.getBeer().equals((Object)Beers.BEER_MUG_NIGHT_HOWL_KVASS)) {
            NightHowlStatusEffect.playRandomHowlSound(world, user);
        }
        if (user instanceof Player && !((Player)user).m_7500_()) {
            ((Player)user).m_36324_().m_38707_(mixedBeerOnUsing.getHunger(), 0.0f);
        }
        if (user instanceof Player) {
            if (!((Player)user).m_7500_()) {
                if (mixedBeerOnUsing.getHealth() < 0.0f) {
                    user.m_6469_((DamageSource)new AlcoholDamage(), Math.abs(mixedBeerOnUsing.getHealth()));
                } else {
                    user.m_5634_(mixedBeerOnUsing.getHealth());
                }
            }
        } else {
            user.m_21153_(user.m_21223_() + mixedBeerOnUsing.getHealth());
        }
        for (org.apache.commons.lang3.tuple.Pair<MobEffect, Integer> statusEffectPair : mixedBeerOnUsing.getStatusEffectList()) {
            user.m_7292_(new MobEffectInstance((MobEffect)statusEffectPair.getKey(), ((Integer)statusEffectPair.getValue()).intValue()));
        }
        SpiceAndFlavorManager.applyFlavorAction(mixedBeerOnUsing, world, user);
    }

    private static List<org.apache.commons.lang3.tuple.Pair<MobEffect, Integer>> getBeerStatusEffectList(Item beerItem, Level world) {
        ArrayList<org.apache.commons.lang3.tuple.Pair<MobEffect, Integer>> resultStatusEffectList = new ArrayList<org.apache.commons.lang3.tuple.Pair<MobEffect, Integer>>();
        List statusEffectList = Objects.requireNonNull(beerItem.m_41473_().m_38749_());
        if (statusEffectList != null && !statusEffectList.isEmpty()) {
            for (Pair statusEffect : statusEffectList) {
                resultStatusEffectList.add((org.apache.commons.lang3.tuple.Pair<MobEffect, Integer>)org.apache.commons.lang3.tuple.Pair.of((Object)((MobEffectInstance)statusEffect.getFirst()).m_19544_(), (Object)((MobEffectInstance)statusEffect.getFirst()).m_19557_()));
            }
        }
        if (beerItem.equals(Beers.BEER_MUG_NIGHT_HOWL_KVASS.getBeerItem())) {
            org.apache.commons.lang3.tuple.Pair<MobEffect, Integer> nightHowlStatusEffectPair = NightHowlStatusEffect.getStatusEffectPair(world);
            resultStatusEffectList.add(nightHowlStatusEffectPair);
        }
        return resultStatusEffectList;
    }

    public static int getActionedTimes(int index, Flavors targetAction, List<Flavors> actionList) {
        if (index == 0) {
            return 0;
        }
        int actionTime = 0;
        for (int i = 0; i < index; ++i) {
            if (!actionList.get(i).equals((Object)targetAction)) continue;
            ++actionTime;
        }
        return actionTime;
    }

    public static boolean hasActionedBefore(int index, Flavors targetAction, List<Flavors> actionList) {
        return MixedBeerManager.getActionedTimes(index, targetAction, actionList) != 0;
    }

    public static boolean hasActionAfter(int index, Flavors targetAction, List<Flavors> actionList) {
        if (actionList.size() - 1 == index) {
            return false;
        }
        for (int i = index + 1; i < actionList.size(); ++i) {
            if (!actionList.get(i).equals((Object)targetAction)) continue;
            return true;
        }
        return false;
    }
}

