/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KineticDebugger {
    public static boolean rainbowDebug = false;

    public static void tick() {
        if (!KineticDebugger.isActive()) {
            if (KineticBlockEntityRenderer.rainbowMode) {
                KineticBlockEntityRenderer.rainbowMode = false;
                SuperByteBufferCache.getInstance().invalidate();
            }
            return;
        }
        KineticBlockEntity be = KineticDebugger.getSelectedBE();
        if (be == null) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockPos toOutline = be.hasSource() ? be.source : be.m_58899_();
        BlockState state = be.m_58900_();
        VoxelShape shape = world.m_8055_(toOutline).m_60816_((BlockGetter)world, toOutline);
        if (be.getTheoreticalSpeed() != 0.0f && !shape.m_83281_()) {
            Outliner.getInstance().chaseAABB((Object)"kineticSource", shape.m_83215_().m_82338_(toOutline)).lineWidth(0.0625f).colored(be.hasSource() ? Color.generateFromLong((long)be.network).getRGB() : 0xFFCC00);
        }
        if (state.m_60734_() instanceof IRotate) {
            Direction.Axis axis = ((IRotate)state.m_60734_()).getRotationAxis(state);
            Vec3 vec = Vec3.m_82528_((Vec3i)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).m_122436_());
            Vec3 center = VecHelper.getCenterOf((Vec3i)be.m_58899_());
            Outliner.getInstance().showLine((Object)"rotationAxis", center.m_82549_(vec), center.m_82546_(vec)).lineWidth(0.0625f);
        }
    }

    public static boolean isActive() {
        return KineticDebugger.isF3DebugModeActive() && rainbowDebug;
    }

    public static boolean isF3DebugModeActive() {
        return Minecraft.m_91087_().f_91066_.f_92063_;
    }

    public static KineticBlockEntity getSelectedBE() {
        HitResult obj = Minecraft.m_91087_().f_91077_;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (obj == null) {
            return null;
        }
        if (world == null) {
            return null;
        }
        if (!(obj instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult ray = (BlockHitResult)obj;
        BlockEntity be = world.m_7702_(ray.m_82425_());
        if (!(be instanceof KineticBlockEntity)) {
            return null;
        }
        return (KineticBlockEntity)be;
    }
}

