/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.particle.WeatherParticle;

public class CustomParticle
extends WeatherParticle {
    private static final Set<String> usuallyUntintableSprites = Set.of("particlerain:rain_0", "particlerain:rain_1", "particlerain:rain_2", "particlerain:rain_3");
    public ConfigData.ParticleData opts;
    private float oCollisionAnimProgress = 1.0f;
    private float collisionAnimProgress = 1.0f;
    private float speed = 0.0f;
    private final float rotationVariation;
    boolean doCollisionAnim = false;
    public BlockPos.MutableBlockPos pos;
    protected BlockPos.MutableBlockPos oPos;
    BlockHitResult collision = null;
    float baseTemp;
    float oQuadSize;
    float distance;

    public CustomParticle(ClientLevel level, double x, double y, double z, ConfigData.ParticleData opts) {
        super(level, x, y, z, VersionUtil.getSprite(VersionUtil.parseId(opts.spriteLocations.get(level.f_46441_.m_188503_(opts.spriteLocations.size())))));
        this.f_107226_ = opts.gravity;
        this.f_107216_ = -this.f_107226_;
        this.f_107663_ = opts.size;
        this.f_107230_ = 0.0f;
        this.f_107219_ = false;
        this.m_107250_(this.f_107663_, this.f_107663_);
        this.f_107225_ = ConfigManager.config.perf.particleDistance * 100;
        this.pos = new BlockPos.MutableBlockPos(x, y, z);
        this.oPos = new BlockPos.MutableBlockPos(x, y, z);
        this.baseTemp = ((Biome)level.m_204166_((BlockPos)this.pos).m_203334_()).m_47554_();
        this.opts = opts;
        this.f_107225_ = opts.lifetime;
        this.rotationVariation = opts.rotationAmount * ((this.f_107223_.m_188501_() - 0.5f) * 2.0f);
        this.f_107663_ = opts.constantScreenSize ? this.getDistanceSize() : opts.size;
        if (!usuallyUntintableSprites.contains(this.f_108321_.m_245424_().m_246162_().toString()) || ConfigManager.config.compat.waterTint) {
            opts.tintType.applyTint((SingleQuadParticle)this, level, (BlockPos)this.pos, opts);
        }
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.oQuadSize = this.f_107663_;
        this.distance = (float)VersionUtil.camPos(Minecraft.m_91087_().f_91063_.m_109153_()).m_82554_(new Vec3(this.f_107212_, this.f_107213_, this.f_107214_));
        this.pos.m_122169_(this.f_107212_, this.f_107213_, this.f_107214_);
        if (!this.pos.equals((Object)this.oPos)) {
            this.onPositionUpdate();
            this.oPos.m_122190_((Vec3i)this.pos);
        }
        if (this.doCollisionAnim) {
            this.tickCollisionAnim();
        }
        this.tickDistanceFade();
        this.speed = (float)new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82553_();
        if (this.opts.constantScreenSize && !this.doCollisionAnim) {
            this.f_107663_ = this.getDistanceSize();
        }
        if (this.opts.rotationAmount != 0.0f) {
            this.f_107204_ = this.f_107231_;
            this.f_107231_ += this.rotationVariation * this.speed;
        }
        this.tickWind();
    }

    @Override
    public void tickDistanceFade() {
        float renderDistance = ConfigManager.config.perf.particleDistance;
        if (this.distance > renderDistance + 1.0f) {
            this.m_107274_();
        } else {
            this.f_107230_ = Mth.m_14179_((float)Mth.m_14036_((float)(this.distance / renderDistance), (float)0.0f, (float)1.0f), (float)this.opts.opacity, (float)0.0f);
        }
    }

    public void tickWind() {
        float multiplier;
        float frequency = ConfigManager.config.wind.gustFrequency;
        float shift = (float)ParticleRain.clientTicks * ConfigManager.config.wind.modulationSpeed;
        float variance = ConfigManager.config.wind.strengthVariance;
        float strength = ConfigManager.config.wind.strength;
        float f = multiplier = this.f_107208_.m_46470_() ? this.opts.stormWindStrength : this.opts.windStrength;
        if (ConfigManager.config.wind.yLevelAdjustment) {
            multiplier *= CustomParticle.yLevelWindMultiplier(this.f_107213_);
        }
        this.f_107215_ = (Mth.m_14031_((float)((float)this.f_107212_ * frequency + shift)) * variance + variance + strength) * multiplier + 0.001f;
        this.f_107217_ = (Mth.m_14031_((float)((float)this.f_107214_ * frequency + shift)) * variance + variance + strength) * multiplier + 0.001f;
    }

    public static float yLevelWindMultiplier(double y) {
        int transitionStart = 50;
        int transitionDistance = 40;
        return (float)Mth.m_14008_((double)((y - (double)transitionStart) / (double)transitionDistance), (double)0.0, (double)1.0);
    }

    @Override
    public void onPositionUpdate() {
        if (!ConfigManager.config.compat.crossBiomeBorder && (double)Mth.m_14154_((float)(((Biome)this.f_107208_.m_204166_((BlockPos)this.pos).m_203334_()).m_47554_() - this.baseTemp)) > 0.4) {
            this.doCollisionAnim = true;
        }
        if (this.f_107208_.m_8055_((BlockPos)this.pos).m_60838_((BlockGetter)this.f_107208_, (BlockPos)this.pos) || !this.f_107208_.m_6425_((BlockPos)this.pos).m_76178_()) {
            this.m_107274_();
        }
        this.testForCollisions();
    }

    public void testForCollisions() {
        Vec3 quadEdgePos;
        Vec3 quadCenterPos;
        BlockHitResult hitResult;
        float length = this.f_107663_;
        if (this.opts.rotationType.equals((Object)ConfigData.RotationType.RELATIVE_VELOCITY)) {
            Vec3 camD = Minecraft.m_91087_().m_91288_().m_20184_();
            Vector3f deltaMotion = new Vector3f((float)(this.f_107215_ - camD.f_82479_), (float)(this.f_107216_ - camD.f_82480_), (float)(this.f_107217_ - camD.f_82481_));
            length *= Mth.m_14036_((float)deltaMotion.lengthSquared(), (float)0.2f, (float)1.0f);
        }
        if (!(hitResult = this.f_107208_.m_45547_(VersionUtil.getClipContext(quadCenterPos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_), quadEdgePos = new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82541_().m_82542_((double)length, (double)length, (double)length).m_82520_(this.f_107212_, this.f_107213_, this.f_107214_)))).m_6662_().equals((Object)HitResult.Type.MISS) && !this.doCollisionAnim) {
            this.collision = hitResult;
            this.doCollisionAnim = true;
        }
    }

    @Override
    public void tickCollisionAnim() {
        this.oCollisionAnimProgress = this.collisionAnimProgress;
        this.collisionAnimProgress -= this.speed;
        if (!this.opts.rotationType.equals((Object)ConfigData.RotationType.RELATIVE_VELOCITY)) {
            this.f_107663_ -= this.speed;
        }
        if (this.oCollisionAnimProgress <= 0.0f) {
            this.m_107274_();
        }
    }

    public float getDistanceSize() {
        if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && Minecraft.m_91087_().f_91074_.m_150108_()) {
            return this.distance * this.opts.size * 0.25f;
        }
        return this.distance * this.opts.size;
    }

    @Override
    public ParticleRenderType m_7556_() {
        return this.opts.renderType.get();
    }

    public void m_5744_(VertexConsumer h, Camera camera, float tickPercent) {
        this.opts.rotationType.render(h, camera, tickPercent, this);
    }

    public void renderLookingQuad(VertexConsumer h, Camera camera, float tickPercent) {
        Vec3 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float offsetY = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float offsetZ = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        Vector3f localPos = new Vector3f(offsetX, offsetY, offsetZ);
        Quaternionf quaternion = Axis.f_252436_.m_252961_(Math.atan2((float)offsetX, (float)offsetZ) + (float)java.lang.Math.PI);
        float yAngle = Math.asin((float)(offsetY / localPos.length()));
        quaternion.rotateX(yAngle);
        quaternion.rotateZ(Math.atan2((float)offsetX, (float)offsetZ));
        if (yAngle < -1.0f) {
            this.doCollisionAnim = true;
        }
        quaternion.rotateZ(Mth.m_14179_((float)tickPercent, (float)this.f_107204_, (float)this.f_107231_));
        this.renderRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent);
    }

    public void renderRelativeVelocityQuad(VertexConsumer h, Camera camera, float tickPercent) {
        float collisionProg;
        Vec3 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float offsetY = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float offsetZ = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        Vec3 camD = Minecraft.m_91087_().m_91288_().m_20184_();
        Vector3f deltaMotion = new Vector3f((float)(this.f_107215_ - camD.f_82479_), (float)(this.f_107216_ - camD.f_82480_), (float)(this.f_107217_ - camD.f_82481_));
        float angle = Math.acos((float)new Vector3f((Vector3fc)deltaMotion).normalize().y);
        Vector3f axis = new Vector3f(-deltaMotion.z(), 0.0f, deltaMotion.x()).normalize();
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        Vector3f transformedOffset = new Vector3f(offsetX, offsetY, offsetZ);
        transformedOffset.rotateAxis(angle, axis.x, axis.y, axis.z);
        quaternion.mul((Quaternionfc)Axis.f_252436_.m_252961_(Math.atan2((float)transformedOffset.x, (float)transformedOffset.z) + (float)java.lang.Math.PI));
        float stretchFactor = Mth.m_14036_((float)deltaMotion.lengthSquared(), (float)0.25f, (float)1.0f);
        if (this.doCollisionAnim && (collisionProg = Mth.m_14179_((float)tickPercent, (float)this.oCollisionAnimProgress, (float)this.collisionAnimProgress)) < stretchFactor) {
            stretchFactor = collisionProg;
        }
        this.renderSquishyRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent, stretchFactor);
    }

    public void renderWorldVelocityQuad(VertexConsumer h, Camera camera, float tickPercent) {
        float collisionProg;
        Vec3 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float offsetY = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float offsetZ = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        Vector3f deltaMotion = new Vector3f((float)this.f_107215_, (float)this.f_107216_, (float)this.f_107217_);
        float angle = Math.acos((float)new Vector3f((Vector3fc)deltaMotion).normalize().y);
        Vector3f axis = new Vector3f(-deltaMotion.z(), 0.0f, deltaMotion.x()).normalize();
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        Vector3f transformedOffset = new Vector3f(offsetX, offsetY, offsetZ);
        transformedOffset.rotateAxis(angle, axis.x, axis.y, axis.z);
        quaternion.mul((Quaternionfc)Axis.f_252436_.m_252961_(Math.atan2((float)transformedOffset.x, (float)transformedOffset.z) + (float)java.lang.Math.PI));
        float stretchFactor = Mth.m_14036_((float)deltaMotion.lengthSquared(), (float)0.25f, (float)1.0f);
        if (this.doCollisionAnim && (collisionProg = Mth.m_14179_((float)tickPercent, (float)this.oCollisionAnimProgress, (float)this.collisionAnimProgress)) < stretchFactor) {
            stretchFactor = collisionProg;
        }
        this.renderSquishyRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent, stretchFactor);
    }

    public void renderCameraCopyQuad(VertexConsumer h, Camera camera, float tickPercent) {
        Vec3 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float offsetY = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float offsetZ = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        Quaternionf quaternion = new Quaternionf((Quaternionfc)camera.m_253121_());
        if (this.f_107231_ != 0.0f) {
            quaternion.rotateZ(Mth.m_14179_((float)tickPercent, (float)this.f_107204_, (float)this.f_107231_));
        }
        quaternion.mul((Quaternionfc)Axis.f_252436_.m_252961_((float)java.lang.Math.PI));
        this.renderRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent);
    }

    private void renderSquishyRotatedQuad(VertexConsumer h, Quaternionf quaternion, float x, float y, float z, float tickPercent, float squish) {
        float size = this.m_5902_(tickPercent);
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int color = this.m_6355_(tickPercent);
        this.renderVertex(h, quaternion, x, y, z, 1.0f, -squish, size, u1, v1, color);
        this.renderVertex(h, quaternion, x, y, z, 1.0f, squish, size, u1, v0, color);
        this.renderVertex(h, quaternion, x, y, z, -1.0f, squish, size, u0, v0, color);
        this.renderVertex(h, quaternion, x, y, z, -1.0f, -squish, size, u0, v1, color);
    }

    private void renderVertex(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vec = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)quaternion).mul(quadSize).add(x, y, z);
        buffer.m_5483_((double)vec.x(), (double)vec.y(), (double)vec.z()).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(packedLight).m_5752_();
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        ConfigData.ParticleData opts;

        public DefaultFactory(ConfigData.ParticleData opts) {
            this.opts = opts;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            for (ConfigData.ParticleData options : ConfigManager.config.particles) {
                if (!this.opts.id.equals(options.id)) continue;
                this.opts = options;
            }
            return new CustomParticle(level, x, y, z, this.opts);
        }
    }
}

