/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import java.net.URI;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.config.gui.Annotations;

public abstract class Whitelist<T> {
    @Annotations.NoGUI
    private final transient ResourceKey<Registry<T>> registry;
    @Annotations.NoGUI
    public transient ArrayList<TagKey<T>> tags = new ArrayList();
    @Annotations.NoGUI
    public transient ArrayList<ResourceLocation> ids = new ArrayList();
    @Annotations.BooleanFormat(t="whitelist", f="blacklist")
    public boolean isWhitelist;

    Whitelist(ResourceKey<Registry<T>> registry, boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
        this.registry = registry;
    }

    Whitelist(ResourceKey<Registry<T>> registry) {
        this(registry, true);
    }

    public abstract ArrayList<String> getEntries();

    public String toString() {
        return this.getEntries().toString();
    }

    public void populateInternalLists() {
        this.ids.clear();
        this.tags.clear();
        for (String string : this.getEntries()) {
            ResourceLocation id;
            if (string.startsWith("#")) {
                id = VersionUtil.parseId(string.substring(1));
                if (id == null) continue;
                this.tags.add(TagKey.m_203882_(this.registry, (ResourceLocation)id));
                continue;
            }
            id = VersionUtil.parseId(string);
            if (id == null) continue;
            this.ids.add(id);
        }
    }

    public boolean contains(Holder<T> holder) {
        if (!this.getEntries().isEmpty()) {
            boolean hasMatch;
            for (TagKey<T> tag : this.tags) {
                hasMatch = holder.m_203656_(tag);
                if (this.isWhitelist && hasMatch) {
                    return true;
                }
                if (!hasMatch) continue;
                return false;
            }
            for (ResourceLocation id : this.ids) {
                hasMatch = holder.m_203373_(id);
                if (this.isWhitelist && hasMatch) {
                    return true;
                }
                if (!hasMatch) continue;
                return false;
            }
            return !this.isWhitelist;
        }
        return true;
    }

    @Annotations.OverrideName(value="Whitelist")
    public static class BiomeList
    extends Whitelist<Biome> {
        public final transient URI wikiLink = URI.create("https://wiki.fabricmc.net/community:common_tags#biome_tags");
        @Annotations.NoSubMenu
        @Annotations.Dropdown(value=ConfigManager.SupplyBiomes.class)
        public ArrayList<String> entries;

        BiomeList(boolean isWhitelist, ArrayList<String> list) {
            super(Registries.f_256952_, isWhitelist);
            this.entries = list;
        }

        public BiomeList() {
            super(Registries.f_256952_);
            this.entries = new ArrayList();
        }

        @Override
        public ArrayList<String> getEntries() {
            return this.entries;
        }
    }

    @Annotations.OverrideName(value="Whitelist")
    public static class BlockList
    extends Whitelist<Block> {
        public final transient URI wikiLink = URI.create("https://wiki.fabricmc.net/community:common_tags#block_tags");
        @Annotations.NoSubMenu
        @Annotations.Dropdown(value=ConfigManager.SupplyBlocks.class)
        public ArrayList<String> entries;

        BlockList(boolean isWhitelist, ArrayList<String> list) {
            super(Registries.f_256747_, isWhitelist);
            this.entries = list;
        }

        public BlockList() {
            super(Registries.f_256747_);
            this.entries = new ArrayList();
        }

        @Override
        public ArrayList<String> getEntries() {
            return this.entries;
        }
    }
}

