/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.player;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.event.EventSubscription;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeClearEvent;
import net.luckperms.api.event.node.NodeMutateEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.model.PermissionHolder;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.event.Event;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.event.player.PlayerPermissionUpdateEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lsu/plo/voice/server/player/LuckPermsListener;", "", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "<init>", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Ljava/util/concurrent/ScheduledExecutorService;)V", "luckPerms", "Lnet/luckperms/api/LuckPerms;", "subscriptions", "", "Lnet/luckperms/api/event/EventSubscription;", "permissionChanges", "", "", "Ljava/util/concurrent/ScheduledFuture;", "subscribe", "", "unsubscribe", "onNodeAdd", "event", "Lnet/luckperms/api/event/node/NodeAddEvent;", "onNodeRemove", "Lnet/luckperms/api/event/node/NodeRemoveEvent;", "onNodeClear", "Lnet/luckperms/api/event/node/NodeClearEvent;", "onNodeMutate", "Lnet/luckperms/api/event/node/NodeMutateEvent;", "node", "Lnet/luckperms/api/node/Node;", "onLpPermissionChange", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "permission", "onPermissionChange", "Companion", "server-proxy-common"})
@SourceDebugExtension(value={"SMAP\nLuckPermsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuckPermsListener.kt\nsu/plo/voice/server/player/LuckPermsListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1863#2,2:117\n1863#2,2:119\n1863#2,2:121\n*S KotlinDebug\n*F\n+ 1 LuckPermsListener.kt\nsu/plo/voice/server/player/LuckPermsListener\n*L\n50#1:117,2\n62#1:119,2\n79#1:121,2\n*E\n"})
public final class LuckPermsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlasmoBaseVoiceServer voiceServer;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final LuckPerms luckPerms;
    @NotNull
    private final List<EventSubscription<?>> subscriptions;
    @NotNull
    private final Map<String, ScheduledFuture<?>> permissionChanges;

    public LuckPermsListener(@NotNull PlasmoBaseVoiceServer voiceServer, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(executor, "executor");
        this.voiceServer = voiceServer;
        this.executor = executor;
        LuckPerms luckPerms = LuckPermsProvider.get();
        Intrinsics.checkNotNullExpressionValue(luckPerms, "get(...)");
        this.luckPerms = luckPerms;
        this.subscriptions = new ArrayList();
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue(hashMap, "newHashMap(...)");
        this.permissionChanges = hashMap;
    }

    public final void subscribe() {
        EventBus eventBus = this.luckPerms.getEventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "getEventBus(...)");
        EventBus luckPermsBus = eventBus;
        EventSubscription eventSubscription = luckPermsBus.subscribe(NodeAddEvent.class, arg_0 -> LuckPermsListener.subscribe$lambda$0(new Function1<NodeAddEvent, Unit>((Object)this){

            public final void invoke(NodeAddEvent p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                LuckPermsListener.access$onNodeAdd((LuckPermsListener)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(eventSubscription, "subscribe(...)");
        this.subscriptions.add(eventSubscription);
        eventSubscription = luckPermsBus.subscribe(NodeRemoveEvent.class, arg_0 -> LuckPermsListener.subscribe$lambda$1(new Function1<NodeRemoveEvent, Unit>((Object)this){

            public final void invoke(NodeRemoveEvent p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                LuckPermsListener.access$onNodeRemove((LuckPermsListener)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(eventSubscription, "subscribe(...)");
        this.subscriptions.add(eventSubscription);
        eventSubscription = luckPermsBus.subscribe(NodeClearEvent.class, arg_0 -> LuckPermsListener.subscribe$lambda$2(new Function1<NodeClearEvent, Unit>((Object)this){

            public final void invoke(NodeClearEvent p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                LuckPermsListener.access$onNodeClear((LuckPermsListener)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(eventSubscription, "subscribe(...)");
        this.subscriptions.add(eventSubscription);
    }

    public final void unsubscribe() {
        Iterable $this$forEach$iv = this.subscriptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventSubscription it = (EventSubscription)element$iv;
            boolean bl = false;
            it.close();
        }
    }

    private final void onNodeAdd(NodeAddEvent event) {
        NodeMutateEvent nodeMutateEvent = (NodeMutateEvent)event;
        Node node = event.getNode();
        Intrinsics.checkNotNullExpressionValue(node, "getNode(...)");
        this.onNodeMutate(nodeMutateEvent, node);
    }

    private final void onNodeRemove(NodeRemoveEvent event) {
        NodeMutateEvent nodeMutateEvent = (NodeMutateEvent)event;
        Node node = event.getNode();
        Intrinsics.checkNotNullExpressionValue(node, "getNode(...)");
        this.onNodeMutate(nodeMutateEvent, node);
    }

    private final void onNodeClear(NodeClearEvent event) {
        Set set = event.getNodes();
        Intrinsics.checkNotNullExpressionValue(set, "getNodes(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            NodeMutateEvent nodeMutateEvent = (NodeMutateEvent)event;
            Intrinsics.checkNotNull(it);
            this.onNodeMutate(nodeMutateEvent, it);
        }
    }

    private final void onNodeMutate(NodeMutateEvent event, Node node) {
        if (event.isUser()) {
            PermissionHolder permissionHolder = event.getTarget();
            Intrinsics.checkNotNull(permissionHolder, "null cannot be cast to non-null type net.luckperms.api.model.user.User");
            User user = (User)permissionHolder;
            VoicePlayer voicePlayer = this.voiceServer.getPlayerManager().getPlayerById(user.getUniqueId(), false).orElse(null);
            if (voicePlayer == null) {
                return;
            }
            VoicePlayer player = voicePlayer;
            if (!player.hasVoiceChat()) {
                return;
            }
            String string = node.getKey();
            Intrinsics.checkNotNullExpressionValue(string, "getKey(...)");
            this.onLpPermissionChange(player, string);
        } else if (event.isGroup()) {
            PermissionHolder permissionHolder = event.getTarget();
            Intrinsics.checkNotNull(permissionHolder, "null cannot be cast to non-null type net.luckperms.api.model.group.Group");
            Group group = (Group)permissionHolder;
            Collection<?> collection = this.voiceServer.getPlayerManager().getPlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getPlayers(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VoicePlayer player = (VoicePlayer)element$iv;
                boolean bl = false;
                if (!player.getInstance().hasPermission("group." + group.getName())) continue;
                Intrinsics.checkNotNull(player);
                String string = node.getKey();
                Intrinsics.checkNotNullExpressionValue(string, "getKey(...)");
                this.onLpPermissionChange(player, string);
            }
        }
    }

    private final synchronized void onLpPermissionChange(VoicePlayer player, String permission) {
        ScheduledFuture<?> future;
        String playerPermissionKey = player.getInstance().getUuid() + '_' + permission;
        ScheduledFuture<?> scheduledFuture = future = this.permissionChanges.get(playerPermissionKey);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.permissionChanges.put(player.getInstance().getUuid() + '_' + permission, this.executor.schedule(() -> LuckPermsListener.onLpPermissionChange$lambda$6(this, player, permission), 100L, TimeUnit.MILLISECONDS));
    }

    private final void onPermissionChange(VoicePlayer player, String permission) {
        this.voiceServer.getEventBus().fire((Event)new PlayerPermissionUpdateEvent(player, permission));
        this.permissionChanges.remove(player.getInstance().getUuid() + '_' + permission);
    }

    private static final void subscribe$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void onLpPermissionChange$lambda$6(LuckPermsListener this$0, VoicePlayer $player, String $permission) {
        this$0.onPermissionChange($player, $permission);
    }

    public static final /* synthetic */ void access$onNodeAdd(LuckPermsListener $this, NodeAddEvent event) {
        $this.onNodeAdd(event);
    }

    public static final /* synthetic */ void access$onNodeRemove(LuckPermsListener $this, NodeRemoveEvent event) {
        $this.onNodeRemove(event);
    }

    public static final /* synthetic */ void access$onNodeClear(LuckPermsListener $this, NodeClearEvent event) {
        $this.onNodeClear(event);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lsu/plo/voice/server/player/LuckPermsListener$Companion;", "", "<init>", "()V", "hasLuckPerms", "", "server-proxy-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasLuckPerms() {
            boolean bl;
            try {
                Class.forName("net.luckperms.api.LuckPermsProvider");
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

