/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.sun.jna.Platform;
import java.awt.Color;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.ConfigEntry;
import su.plo.lib.mod.client.MinecraftUtil;
import su.plo.lib.mod.client.ResourceLocationUtil;
import su.plo.lib.mod.client.gui.components.IconButton;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AlContextOutputDevice;
import su.plo.voice.api.client.audio.device.AudioDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.DeviceFactory;
import su.plo.voice.api.client.audio.device.DeviceFactoryManager;
import su.plo.voice.api.client.audio.device.DeviceManager;
import su.plo.voice.api.client.audio.device.InputDevice;
import su.plo.voice.api.client.event.audio.device.DeviceClosedEvent;
import su.plo.voice.api.client.event.audio.device.DeviceOpenEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.gui.GuiUtil;
import su.plo.voice.client.gui.settings.MicrophoneTestController;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.widget.ActivationThresholdWidget;
import su.plo.voice.client.gui.settings.widget.CompositeRowWidget;
import su.plo.voice.client.gui.settings.widget.DropDownWidget;
import su.plo.voice.client.gui.settings.widget.ToggleButton;
import su.plo.voice.client.mac.AVAuthorizationStatus;
import su.plo.voice.client.mac.AVCaptureDevice;

public final class DevicesTabWidget
extends TabWidget {
    private final MicrophoneTestController testController;
    private final DeviceManager devices;
    private final DeviceFactoryManager deviceFactories;
    private ActivationThresholdWidget threshold;

    public DevicesTabWidget(VoiceSettingsScreen parent, PlasmoVoiceClient voiceClient, VoiceClientConfig config, MicrophoneTestController testController) {
        super(parent, voiceClient, config);
        this.testController = testController;
        this.devices = voiceClient.getDeviceManager();
        this.deviceFactories = voiceClient.getDeviceFactoryManager();
    }

    @Override
    public void init() {
        super.init();
        this.addEntry(new TabWidget.CategoryEntry(this, McTextComponent.translatable("gui.plasmovoice.devices.microphone", new Object[0])));
        this.addEntry(this.createThresholdEntry());
        this.addEntry(this.createMicrophoneEntry());
        this.addEntry(this.createVolumeSlider(McTextComponent.translatable("gui.plasmovoice.devices.microphone_volume", new Object[0]), McTextComponent.translatable("gui.plasmovoice.devices.volume.tooltip", new Object[0]), this.config.getVoice().getMicrophoneVolume(), "%"));
        this.addEntry(this.createToggleEntry(McTextComponent.translatable("gui.plasmovoice.devices.noise_suppression", new Object[0]), McTextComponent.translatable("gui.plasmovoice.devices.noise_suppression.tooltip", new Object[0]), this.config.getVoice().getNoiseSuppression()));
        this.addEntry(this.createStereoCaptureEntry());
        this.addEntry(this.createToggleEntry(McTextComponent.translatable("gui.plasmovoice.devices.disable_input_device", new Object[0]), McTextComponent.translatable("gui.plasmovoice.devices.disable_input_device.tooltip", new Object[0]), this.config.getVoice().getDisableInputDevice(), toggled -> {
            try {
                this.devices.getInputDevice().ifPresent(AudioDevice::close);
            }
            catch (Exception e) {
                BaseVoice.LOGGER.error("Failed to disable input device", e);
            }
        }));
        this.addEntry(new TabWidget.CategoryEntry(this, McTextComponent.translatable("gui.plasmovoice.devices.output", new Object[0])));
        this.addEntry(this.createOutputDeviceEntry());
        this.addEntry(this.createVolumeSlider(McTextComponent.translatable("gui.plasmovoice.devices.volume", new Object[0]), McTextComponent.translatable("gui.plasmovoice.devices.volume.tooltip", new Object[0]), this.config.getVoice().getVolume(), "%"));
        this.addEntry(this.createToggleEntry(McTextComponent.translatable("gui.plasmovoice.devices.occlusion", new Object[0]), McTextComponent.translatable("gui.plasmovoice.devices.occlusion.tooltip", new Object[0]), this.config.getVoice().getSoundOcclusion()));
        this.addEntry(this.createToggleEntry(McTextComponent.translatable("gui.plasmovoice.devices.directional_sources", new Object[0]), McTextComponent.translatable("gui.plasmovoice.devices.directional_sources.tooltip", new Object[0]), this.config.getVoice().getDirectionalSources()));
        this.addEntry(this.createHrtfEntry());
    }

    @EventSubscribe
    public void onDeviceOpen(@NotNull DeviceOpenEvent event) {
        Minecraft.m_91087_().execute(this::init);
    }

    @EventSubscribe
    public void onDeviceClose(@NotNull DeviceClosedEvent event) {
        Minecraft.m_91087_().execute(this::init);
    }

    private TabWidget.ButtonOptionEntry<ActivationThresholdWidget> createThresholdEntry() {
        if (this.threshold != null) {
            this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this.threshold);
        }
        this.threshold = new ActivationThresholdWidget((VoiceSettingsScreen)this.parent, this.config.getVoice().getActivationThreshold(), this.voiceClient.getAudioCapture(), this.voiceClient.getDeviceManager(), this.testController, 0, 0, 100, 20);
        this.voiceClient.getEventBus().register(this.voiceClient, this.threshold);
        return new TabWidget.ButtonOptionEntry((TabWidget)this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.devices.activation_threshold", new Object[0]), (GuiAbstractWidget)this.threshold, this.threshold.getButtons(), (ConfigEntry)this.config.getVoice().getActivationThreshold(), (McTextComponent)McTextComponent.translatable("gui.plasmovoice.devices.activation_threshold.tooltip", new Object[0]), null);
    }

    private TabWidget.OptionEntry<CompositeRowWidget> createMicrophoneEntry() {
        Optional<DeviceFactory> deviceFactory;
        if (((Boolean)this.config.getVoice().getUseJavaxInput().value()).booleanValue()) {
            deviceFactory = this.deviceFactories.getDeviceFactory("JAVAX_INPUT");
            if (!deviceFactory.isPresent()) {
                throw new IllegalStateException("Javax Input device factory not initialized");
            }
        } else {
            deviceFactory = this.deviceFactories.getDeviceFactory("AL_INPUT");
            if (!deviceFactory.isPresent()) {
                throw new IllegalStateException("Al Input device factory not initialized");
            }
        }
        ImmutableList<String> inputDeviceNames = deviceFactory.get().getDeviceNames();
        Optional<InputDevice> inputDevice = this.devices.getInputDevice();
        IconButton inputNotAvailable = null;
        if (this.devices.getInputDeviceError().isPresent()) {
            inputNotAvailable = new IconButton(0, 0, 20, 20, button -> MinecraftUtil.openUri("https://plasmovoice.com/docs/client/microphone-not-available"), (button, context, mouseX, mouseY) -> {
                AVAuthorizationStatus authorizationStatus;
                if (Platform.isMac() && (authorizationStatus = AVCaptureDevice.INSTANCE.getAuthorizationStatus()) == AVAuthorizationStatus.RESTRICTED) {
                    ((VoiceSettingsScreen)this.parent).setTooltip(McTextComponent.translatable("message.plasmovoice.macos_incompatible_launcher", McTextComponent.literal("Prism Launcher")));
                    return;
                }
                String configInputDevice = this.config.getVoice().getInputDevice().value();
                McTextComponent currentDeviceName = GuiUtil.formatDeviceName(configInputDevice.isEmpty() ? ((DeviceFactory)deviceFactory.get()).getDefaultDeviceName() : configInputDevice, (DeviceFactory)deviceFactory.get());
                ((VoiceSettingsScreen)this.parent).setTooltip(McTextComponent.translatable("gui.plasmovoice.devices.failed_to_initialize_microphone.tooltip", currentDeviceName));
            }, ResourceLocationUtil.mod("textures/icons/warning.png"), false);
            inputNotAvailable.setIconColor(new Color(16434771));
        }
        DropDownWidget dropdown = new DropDownWidget((VoiceSettingsScreen)this.parent, 0, 0, inputNotAvailable == null ? 124 : 100, 20, GuiUtil.formatDeviceName(inputDevice.orElse(null), deviceFactory.get()), GuiUtil.formatDeviceNames(inputDeviceNames, deviceFactory.get()), true, index -> {
            String deviceName = (String)inputDeviceNames.get(index.intValue());
            if (Objects.equals(deviceName, ((DeviceFactory)deviceFactory.get()).getDefaultDeviceName())) {
                deviceName = null;
            }
            this.config.getVoice().getInputDevice().set(Strings.nullToEmpty((String)deviceName));
            this.config.save(true);
            this.reloadInputDevice();
        });
        dropdown.setActive(!inputDeviceNames.isEmpty() && (Boolean)this.config.getVoice().getDisableInputDevice().value() == false);
        CompositeRowWidget row = new CompositeRowWidget(0, 0, 124, 20, 4, dropdown, inputNotAvailable);
        return new TabWidget.OptionEntry((TabWidget)this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.devices.microphone", new Object[0]), (GuiAbstractWidget)row, this.config.getVoice().getInputDevice(), (button, element) -> {
            dropdown.setText(GuiUtil.formatDeviceName((String)null, (DeviceFactory)deviceFactory.get()));
            this.reloadInputDevice();
        });
    }

    private TabWidget.OptionEntry<ToggleButton> createStereoCaptureEntry() {
        Runnable onUpdate = () -> {
            this.reloadInputDevice();
            this.testController.restart();
        };
        ToggleButton toggleButton = new ToggleButton(this.config.getVoice().getStereoCapture(), 0, 0, 124, 20, toggled -> onUpdate.run());
        return new TabWidget.OptionEntry((TabWidget)this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.devices.stereo_capture", new Object[0]), (GuiAbstractWidget)toggleButton, (ConfigEntry)this.config.getVoice().getStereoCapture(), (McTextComponent)McTextComponent.translatable("gui.plasmovoice.devices.stereo_capture.tooltip", new Object[0]), (button, element) -> onUpdate.run());
    }

    private TabWidget.OptionEntry<DropDownWidget> createOutputDeviceEntry() {
        Optional<DeviceFactory> deviceFactory = this.deviceFactories.getDeviceFactory("AL_OUTPUT");
        if (!deviceFactory.isPresent()) {
            throw new IllegalStateException("Al Output device factory not initialized");
        }
        ImmutableList<String> outputDeviceNames = deviceFactory.get().getDeviceNames();
        Optional<AlContextOutputDevice> outputDevice = this.devices.getOutputDevice();
        DropDownWidget dropdown = new DropDownWidget((VoiceSettingsScreen)this.parent, 0, 0, 124, 20, GuiUtil.formatDeviceName(outputDevice.orElse(null), deviceFactory.get()), GuiUtil.formatDeviceNames(outputDeviceNames, deviceFactory.get()), true, index -> {
            String deviceName = (String)outputDeviceNames.get(index.intValue());
            if (Objects.equals(deviceName, ((DeviceFactory)deviceFactory.get()).getDefaultDeviceName())) {
                deviceName = null;
            }
            this.config.getVoice().getOutputDevice().set(Strings.nullToEmpty((String)deviceName));
            this.config.save(true);
            this.reloadOutputDevice();
        });
        dropdown.setActive(!outputDeviceNames.isEmpty());
        return new TabWidget.OptionEntry((TabWidget)this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.devices.output_device", new Object[0]), (GuiAbstractWidget)dropdown, this.config.getVoice().getOutputDevice(), (button, element) -> {
            element.setText(GuiUtil.formatDeviceName((String)null, (DeviceFactory)deviceFactory.get()));
            this.reloadOutputDevice();
        });
    }

    private TabWidget.OptionEntry<ToggleButton> createHrtfEntry() {
        Consumer<Boolean> onUpdate = toggled -> this.devices.getOutputDevice().ifPresent(device -> {
            try {
                device.reload();
            }
            catch (DeviceException e) {
                BaseVoice.LOGGER.warn("Failed to reload device: {}", e.getMessage());
                e.printStackTrace();
            }
        });
        ToggleButton toggleButton = new ToggleButton(this.config.getVoice().getHrtf(), 0, 0, 124, 20, onUpdate::accept);
        return new TabWidget.OptionEntry((TabWidget)this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.devices.hrtf", new Object[0]), (GuiAbstractWidget)toggleButton, (ConfigEntry)this.config.getVoice().getHrtf(), (McTextComponent)McTextComponent.translatable("gui.plasmovoice.devices.hrtf.tooltip", new Object[0]), (button, element) -> onUpdate.accept((Boolean)this.config.getVoice().getHrtf().value()));
    }

    private void reloadOutputDevice() {
        try {
            this.devices.getOutputDevice().ifPresent(AudioDevice::close);
            AlContextOutputDevice newDevice = this.devices.openOutputDevice(null);
            this.devices.setOutputDevice(newDevice);
            this.testController.restart();
            Minecraft.m_91087_().execute(this::init);
        }
        catch (Exception e) {
            BaseVoice.LOGGER.error("Failed to open primary OpenAL output device", e);
        }
    }

    private void reloadInputDevice() {
        if (((Boolean)this.config.getVoice().getDisableInputDevice().value()).booleanValue()) {
            return;
        }
        try {
            this.devices.getInputDevice().ifPresent(AudioDevice::close);
            InputDevice newDevice = this.devices.openInputDevice(null);
            this.devices.setInputDevice(newDevice);
            Minecraft.m_91087_().execute(this::init);
        }
        catch (Exception e) {
            BaseVoice.LOGGER.error("Failed to open input device", e);
        }
    }
}

