/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.libs.adventure.adventure.text;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.libs.adventure.adventure.internal.Internals;
import su.plo.slib.libs.adventure.adventure.key.Key;
import su.plo.slib.libs.adventure.adventure.text.AbstractNBTComponentBuilder;
import su.plo.slib.libs.adventure.adventure.text.Component;
import su.plo.slib.libs.adventure.adventure.text.ComponentLike;
import su.plo.slib.libs.adventure.adventure.text.NBTComponentImpl;
import su.plo.slib.libs.adventure.adventure.text.StorageNBTComponent;
import su.plo.slib.libs.adventure.adventure.text.format.Style;

final class StorageNBTComponentImpl
extends NBTComponentImpl<StorageNBTComponent, StorageNBTComponent.Builder>
implements StorageNBTComponent {
    private final Key storage;

    @NotNull
    static StorageNBTComponent create(@NotNull List<? extends ComponentLike> children2, @NotNull Style style, String nbtPath, boolean interpret, @Nullable ComponentLike separator, @NotNull Key storage) {
        return new StorageNBTComponentImpl(ComponentLike.asComponents(children2, IS_NOT_EMPTY), Objects.requireNonNull(style, "style"), Objects.requireNonNull(nbtPath, "nbtPath"), interpret, ComponentLike.unbox(separator), Objects.requireNonNull(storage, "storage"));
    }

    StorageNBTComponentImpl(@NotNull List<Component> children2, @NotNull Style style, String nbtPath, boolean interpret, @Nullable Component separator, Key storage) {
        super(children2, style, nbtPath, interpret, separator);
        this.storage = storage;
    }

    @Override
    @NotNull
    public StorageNBTComponent nbtPath(@NotNull String nbtPath) {
        if (Objects.equals(this.nbtPath, nbtPath)) {
            return this;
        }
        return StorageNBTComponentImpl.create(this.children, this.style, nbtPath, this.interpret, this.separator, this.storage);
    }

    @Override
    @NotNull
    public StorageNBTComponent interpret(boolean interpret) {
        if (this.interpret == interpret) {
            return this;
        }
        return StorageNBTComponentImpl.create(this.children, this.style, this.nbtPath, interpret, this.separator, this.storage);
    }

    @Override
    @Nullable
    public Component separator() {
        return this.separator;
    }

    @Override
    @NotNull
    public StorageNBTComponent separator(@Nullable ComponentLike separator) {
        return StorageNBTComponentImpl.create(this.children, this.style, this.nbtPath, this.interpret, separator, this.storage);
    }

    @Override
    @NotNull
    public Key storage() {
        return this.storage;
    }

    @Override
    @NotNull
    public StorageNBTComponent storage(@NotNull Key storage) {
        if (Objects.equals(this.storage, storage)) {
            return this;
        }
        return StorageNBTComponentImpl.create(this.children, this.style, this.nbtPath, this.interpret, this.separator, storage);
    }

    @Override
    @NotNull
    public StorageNBTComponent children(@NotNull List<? extends ComponentLike> children2) {
        return StorageNBTComponentImpl.create(children2, this.style, this.nbtPath, this.interpret, this.separator, this.storage);
    }

    @Override
    @NotNull
    public StorageNBTComponent style(@NotNull Style style) {
        return StorageNBTComponentImpl.create(this.children, style, this.nbtPath, this.interpret, this.separator, this.storage);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StorageNBTComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        StorageNBTComponentImpl that = (StorageNBTComponentImpl)other;
        return Objects.equals(this.storage, that.storage());
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.storage.hashCode();
        return result2;
    }

    @Override
    public String toString() {
        return Internals.toString(this);
    }

    @Override
    public @NotNull StorageNBTComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static class BuilderImpl
    extends AbstractNBTComponentBuilder<StorageNBTComponent, StorageNBTComponent.Builder>
    implements StorageNBTComponent.Builder {
        @Nullable
        private Key storage;

        BuilderImpl() {
        }

        BuilderImpl(@NotNull StorageNBTComponent component) {
            super(component);
            this.storage = component.storage();
        }

        @Override
        public @NotNull StorageNBTComponent.Builder storage(@NotNull Key storage) {
            this.storage = Objects.requireNonNull(storage, "storage");
            return this;
        }

        @Override
        @NotNull
        public StorageNBTComponent build() {
            if (this.nbtPath == null) {
                throw new IllegalStateException("nbt path must be set");
            }
            if (this.storage == null) {
                throw new IllegalStateException("storage must be set");
            }
            return StorageNBTComponentImpl.create(this.children, this.buildStyle(), this.nbtPath, this.interpret, this.separator, this.storage);
        }
    }
}

