/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.physics;

import com.wildfire.api.IGenderArmor;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.phys.Vec3;

public class BreastPhysics {
    private float bounceVel = 0.0f;
    private float targetBounceY = 0.0f;
    private float velocity = 0.0f;
    private float wfg_femaleBreast;
    private float wfg_preBounce;
    private float bounceRotVel = 0.0f;
    private float targetRotVel = 0.0f;
    private float rotVelocity = 0.0f;
    private float wfg_bounceRotation;
    private float wfg_preBounceRotation;
    private float bounceVelX = 0.0f;
    private float targetBounceX = 0.0f;
    private float velocityX = 0.0f;
    private float wfg_femaleBreastX;
    private float wfg_preBounceX;
    private boolean justSneaking = false;
    private boolean alreadySleeping = false;
    private float breastSize = 0.0f;
    private float preBreastSize = 0.0f;
    private Vec3 prePos;
    private final GenderPlayer genderPlayer;
    private int randomB = 1;
    private boolean alreadyFalling = false;

    public BreastPhysics(GenderPlayer genderPlayer) {
        this.genderPlayer = genderPlayer;
    }

    public void update(Player plr, IGenderArmor armor) {
        this.wfg_preBounce = this.wfg_femaleBreast;
        this.wfg_preBounceX = this.wfg_femaleBreastX;
        this.wfg_preBounceRotation = this.wfg_bounceRotation;
        this.preBreastSize = this.breastSize;
        if (this.prePos == null) {
            this.prePos = plr.m_20182_();
            return;
        }
        float breastWeight = this.genderPlayer.getBustSize() * 1.25f;
        float targetBreastSize = this.genderPlayer.getBustSize();
        if (!this.genderPlayer.getGender().canHaveBreasts()) {
            targetBreastSize = 0.0f;
        } else if (!this.genderPlayer.getArmorPhysicsOverride()) {
            float tightness = Mth.m_14036_((float)armor.tightness(), (float)0.0f, (float)1.0f);
            targetBreastSize *= 1.0f - 0.15f * tightness;
        }
        this.breastSize = this.breastSize < targetBreastSize ? (this.breastSize += Math.abs(this.breastSize - targetBreastSize) / 2.0f) : (this.breastSize -= Math.abs(this.breastSize - targetBreastSize) / 2.0f);
        Vec3 motion = plr.m_20182_().m_82546_(this.prePos);
        this.prePos = plr.m_20182_();
        float bounceIntensity = targetBreastSize * 3.0f * this.genderPlayer.getBounceMultiplier();
        if (!this.genderPlayer.getArmorPhysicsOverride()) {
            float resistance = Mth.m_14036_((float)armor.physicsResistance(), (float)0.0f, (float)1.0f);
            bounceIntensity *= 1.0f - resistance;
        }
        if (!this.genderPlayer.getBreasts().isUniboob()) {
            bounceIntensity *= WildfireHelper.randFloat(0.5f, 1.5f);
        }
        if (plr.f_19789_ > 0.0f && !this.alreadyFalling) {
            this.randomB = plr.m_9236_().f_46441_.m_188499_() ? -1 : 1;
            this.alreadyFalling = true;
        }
        if (plr.f_19789_ == 0.0f) {
            this.alreadyFalling = false;
        }
        this.targetBounceY = (float)motion.f_82480_ * bounceIntensity;
        this.targetBounceY += breastWeight;
        this.targetRotVel = -((plr.f_20883_ - plr.f_20884_) / 15.0f) * bounceIntensity;
        float f = (float)plr.m_20184_().m_82556_() / 0.2f;
        if ((f = f * f * f) < 1.0f) {
            f = 1.0f;
        }
        this.targetBounceY += Mth.m_14089_((float)(plr.f_267362_.m_267756_() * 0.6662f + (float)Math.PI)) * 0.5f * plr.f_267362_.m_267731_() * 0.5f / f;
        this.targetRotVel += (float)motion.f_82480_ * bounceIntensity * (float)this.randomB;
        if (plr.m_20089_() == Pose.CROUCHING && !this.justSneaking) {
            this.justSneaking = true;
            this.targetBounceY += bounceIntensity;
        }
        if (plr.m_20089_() != Pose.CROUCHING && this.justSneaking) {
            this.justSneaking = false;
            this.targetBounceY += bounceIntensity;
        }
        if (plr.m_20202_() != null) {
            Entity movement;
            Pig pig;
            Entity movement22;
            float movement22;
            AbstractHorse horse;
            Entity speed2;
            Entity rowTime2;
            Entity entity = plr.m_20202_();
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                int rowTime2 = (int)boat.m_38315_(0, plr.f_267362_.m_267756_());
                int rowTime22 = (int)boat.m_38315_(1, plr.f_267362_.m_267756_());
                float rotationL = (float)Mth.m_14085_((double)-1.0471975803375244, (double)-0.2617993950843811, (double)((Mth.m_14031_((float)(-rowTime22)) + 1.0f) / 2.0f));
                float rotationR = (float)Mth.m_14085_((double)-0.7853981852531433, (double)0.7853981852531433, (double)((Mth.m_14031_((float)((float)(-rowTime2) + 1.0f)) + 1.0f) / 2.0f));
                if (rotationL < -1.0f || rotationR < -0.6f) {
                    this.targetBounceY = bounceIntensity / 3.25f;
                }
            }
            if ((rowTime2 = plr.m_20202_()) instanceof Minecart) {
                Minecart cart = (Minecart)rowTime2;
                float speed2 = (float)cart.m_20184_().m_82556_();
                if (Math.random() * (double)speed2 < 0.5 && speed2 > 0.2f) {
                    this.targetBounceY = (Math.random() > 0.5 ? -bounceIntensity : bounceIntensity) / 6.0f;
                }
            }
            if ((speed2 = plr.m_20202_()) instanceof AbstractHorse && horse.f_19797_ % this.clampMovement(movement22 = (float)(horse = (AbstractHorse)speed2).m_20184_().m_82553_()) == 5 && movement22 > 0.1f) {
                this.targetBounceY = bounceIntensity / 4.0f;
            }
            if ((movement22 = plr.m_20202_()) instanceof Pig && pig.f_19797_ % this.clampMovement(movement = (float)(pig = (Pig)movement22).m_20184_().m_82553_()) == 5 && movement > 0.08f) {
                this.targetBounceY = bounceIntensity / 4.0f;
            }
            if ((movement = plr.m_20202_()) instanceof Strider) {
                Strider strider = (Strider)movement;
                double heightOffset = (double)strider.m_20206_() - 0.19 + (double)(0.12f * Mth.m_14089_((float)(strider.f_267362_.m_267756_() * 1.5f)) * 2.0f * Math.min(0.25f, strider.f_267362_.m_267731_()));
                this.targetBounceY += ((float)(heightOffset * 3.0) - 4.5f) * bounceIntensity;
            }
        }
        if (plr.f_20911_ && plr.f_19797_ % 5 == 0 && plr.m_20089_() != Pose.SLEEPING) {
            this.targetBounceY += (Math.random() > 0.5 ? -0.25f : 0.25f) * bounceIntensity;
        }
        if (plr.m_20089_() == Pose.SLEEPING && !this.alreadySleeping) {
            this.targetBounceY = bounceIntensity;
            this.alreadySleeping = true;
        }
        if (plr.m_20089_() != Pose.SLEEPING && this.alreadySleeping) {
            this.targetBounceY = bounceIntensity;
            this.alreadySleeping = false;
        }
        float percent = this.genderPlayer.getFloppiness();
        float bounceAmount = 0.45f * (1.0f - percent) + 0.15f;
        bounceAmount = Mth.m_14036_((float)bounceAmount, (float)0.15f, (float)0.6f);
        float delta = 2.25f - bounceAmount;
        float distanceFromMin = Math.abs(this.bounceVel + 0.5f) * 0.5f;
        float distanceFromMax = Math.abs(this.bounceVel - 2.65f) * 0.5f;
        if (this.bounceVel < -0.5f) {
            this.targetBounceY += distanceFromMin;
        }
        if (this.bounceVel > 2.5f) {
            this.targetBounceY -= distanceFromMax;
        }
        if (this.targetBounceY < -1.5f) {
            this.targetBounceY = -1.5f;
        }
        if (this.targetBounceY > 2.5f) {
            this.targetBounceY = 2.5f;
        }
        if (this.targetRotVel < -25.0f) {
            this.targetRotVel = -25.0f;
        }
        if (this.targetRotVel > 25.0f) {
            this.targetRotVel = 25.0f;
        }
        this.velocity = Mth.m_14179_((float)bounceAmount, (float)this.velocity, (float)((this.targetBounceY - this.bounceVel) * delta));
        this.bounceVel += this.velocity * percent * 1.1625f;
        this.velocityX = Mth.m_14179_((float)bounceAmount, (float)this.velocityX, (float)((this.targetBounceX - this.bounceVelX) * delta));
        this.bounceVelX += this.velocityX * percent;
        this.rotVelocity = Mth.m_14179_((float)bounceAmount, (float)this.rotVelocity, (float)((this.targetRotVel - this.bounceRotVel) * delta));
        this.bounceRotVel += this.rotVelocity * percent;
        this.wfg_bounceRotation = this.bounceRotVel;
        this.wfg_femaleBreastX = this.bounceVelX;
        this.wfg_femaleBreast = this.bounceVel;
    }

    public float getBreastSize(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.preBreastSize, (float)this.breastSize);
    }

    public float getPreBounceY() {
        return this.wfg_preBounce;
    }

    public float getBounceY() {
        return this.wfg_femaleBreast;
    }

    public float getPreBounceX() {
        return this.wfg_preBounceX;
    }

    public float getBounceX() {
        return this.wfg_femaleBreastX;
    }

    public float getBounceRotation() {
        return this.wfg_bounceRotation;
    }

    public float getPreBounceRotation() {
        return this.wfg_preBounceRotation;
    }

    private int clampMovement(float movement) {
        int val = (int)(10.0f - movement * 2.0f);
        if (val < 1) {
            val = 1;
        }
        return val;
    }
}

