/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.data.recipe.CommonMetal;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;

public class TrackMaterialFactory {
    private final ResourceLocation id;
    private String langName;
    private NonNullSupplier<NonNullSupplier<? extends TrackBlock>> trackBlock;
    private Ingredient sleeperIngredient = Ingredient.f_43901_;
    private Ingredient railsIngredient;
    private ResourceLocation particle;
    private TrackMaterial.TrackType trackType;
    @Nullable
    private TrackMaterial.TrackType.TrackBlockFactory customFactory;
    @OnlyIn(value=Dist.CLIENT)
    private TrackMaterial.TrackModelHolder modelHolder;
    @OnlyIn(value=Dist.CLIENT)
    private PartialModel tieModel;
    @OnlyIn(value=Dist.CLIENT)
    private PartialModel leftSegmentModel;
    @OnlyIn(value=Dist.CLIENT)
    private PartialModel rightSegmentModel;

    public TrackMaterialFactory(ResourceLocation id) {
        this.railsIngredient = Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(CommonMetal.IRON.nuggets), new Ingredient.TagValue(CommonMetal.ZINC.nuggets)));
        this.trackType = TrackMaterial.TrackType.STANDARD;
        this.customFactory = null;
        this.id = id;
    }

    public static TrackMaterialFactory make(ResourceLocation id) {
        return new TrackMaterialFactory(id);
    }

    public TrackMaterialFactory lang(String langName) {
        this.langName = langName;
        return this;
    }

    public TrackMaterialFactory block(NonNullSupplier<NonNullSupplier<? extends TrackBlock>> trackBlock) {
        this.trackBlock = trackBlock;
        return this;
    }

    public TrackMaterialFactory defaultModels() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.modelHolder = TrackMaterial.TrackModelHolder.DEFAULT;
        });
        return this;
    }

    public TrackMaterialFactory sleeper(Ingredient sleeperIngredient) {
        this.sleeperIngredient = sleeperIngredient;
        return this;
    }

    public TrackMaterialFactory sleeper(ItemLike ... items) {
        this.sleeperIngredient = Ingredient.m_43929_((ItemLike[])items);
        return this;
    }

    public TrackMaterialFactory rails(Ingredient railsIngredient) {
        this.railsIngredient = railsIngredient;
        return this;
    }

    public TrackMaterialFactory rails(ItemLike ... items) {
        this.railsIngredient = Ingredient.m_43929_((ItemLike[])items);
        return this;
    }

    public TrackMaterialFactory noRecipeGen() {
        this.railsIngredient = Ingredient.f_43901_;
        this.sleeperIngredient = Ingredient.f_43901_;
        return this;
    }

    public TrackMaterialFactory particle(ResourceLocation particle) {
        this.particle = particle;
        return this;
    }

    public TrackMaterialFactory trackType(TrackMaterial.TrackType trackType) {
        this.trackType = trackType;
        return this;
    }

    public TrackMaterialFactory standardModels() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            String namespace = this.id.m_135827_();
            String prefix = "block/track/" + this.id.m_135815_() + "/";
            this.tieModel = PartialModel.of((ResourceLocation)new ResourceLocation(namespace, prefix + "tie"));
            this.leftSegmentModel = PartialModel.of((ResourceLocation)new ResourceLocation(namespace, prefix + "segment_left"));
            this.rightSegmentModel = PartialModel.of((ResourceLocation)new ResourceLocation(namespace, prefix + "segment_right"));
        });
        return this;
    }

    public TrackMaterialFactory customModels(Supplier<Supplier<PartialModel>> tieModel, Supplier<Supplier<PartialModel>> leftSegmentModel, Supplier<Supplier<PartialModel>> rightSegmentModel) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.lambda$customModels$4((Supplier)tieModel, (Supplier)leftSegmentModel, (Supplier)rightSegmentModel));
        return this;
    }

    public TrackMaterialFactory customBlockFactory(TrackMaterial.TrackType.TrackBlockFactory factory) {
        this.customFactory = factory;
        return this;
    }

    public TrackMaterial build() {
        assert (this.trackBlock != null);
        assert (this.langName != null);
        assert (this.particle != null);
        assert (this.trackType != null);
        assert (this.sleeperIngredient != null);
        assert (this.railsIngredient != null);
        assert (this.id != null);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            assert (this.modelHolder != null);
            if (this.tieModel != null || this.leftSegmentModel != null || this.rightSegmentModel != null) {
                assert (this.tieModel != null && this.leftSegmentModel != null && this.rightSegmentModel != null);
                this.modelHolder = new TrackMaterial.TrackModelHolder(this.tieModel, this.leftSegmentModel, this.rightSegmentModel);
            }
        });
        return new TrackMaterial(this.id, this.langName, this.trackBlock, this.particle, this.sleeperIngredient, this.railsIngredient, this.trackType, () -> () -> this.modelHolder, this.customFactory);
    }

    private /* synthetic */ void lambda$customModels$4(Supplier tieModel, Supplier leftSegmentModel, Supplier rightSegmentModel) {
        this.tieModel = (PartialModel)((Supplier)tieModel.get()).get();
        this.leftSegmentModel = (PartialModel)((Supplier)leftSegmentModel.get()).get();
        this.rightSegmentModel = (PartialModel)((Supplier)rightSegmentModel.get()).get();
    }
}

