/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorage;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.MountedStorageSyncPacket;
import com.simibubi.create.content.equipment.toolbox.ToolboxMountedStorage;
import com.simibubi.create.content.fluids.tank.storage.FluidTankMountedStorage;
import com.simibubi.create.content.fluids.tank.storage.creative.CreativeFluidTankMountedStorage;
import com.simibubi.create.content.logistics.crate.CreativeCrateMountedStorage;
import com.simibubi.create.content.logistics.depot.storage.DepotMountedStorage;
import com.simibubi.create.content.logistics.vault.ItemVaultMountedStorage;
import com.simibubi.create.impl.contraption.storage.FallbackMountedStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class MountedStorageManager {
    private Map<BlockPos, MountedItemStorage> itemsBuilder;
    private Map<BlockPos, MountedFluidStorage> fluidsBuilder;
    private Map<BlockPos, SyncedMountedStorage> syncedItemsBuilder;
    private Map<BlockPos, SyncedMountedStorage> syncedFluidsBuilder;
    private ImmutableMap<BlockPos, MountedItemStorage> allItemStorages;
    protected MountedItemStorageWrapper items;
    @Nullable
    protected MountedItemStorageWrapper fuelItems;
    protected MountedFluidStorageWrapper fluids;
    private ImmutableMap<BlockPos, SyncedMountedStorage> syncedItems;
    private ImmutableMap<BlockPos, SyncedMountedStorage> syncedFluids;
    private List<IItemHandlerModifiable> externalHandlers;
    protected CombinedInvWrapper allItems;
    private int syncCooldown;
    private Set<BlockPos> interactablePositions;

    public MountedStorageManager() {
        this.reset();
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.allItemStorages = ImmutableMap.copyOf(this.itemsBuilder);
        this.items = new MountedItemStorageWrapper(MountedStorageManager.subMap(this.allItemStorages, this::isExposed));
        this.allItems = this.items;
        this.itemsBuilder = null;
        ImmutableMap<BlockPos, MountedItemStorage> fuelMap = MountedStorageManager.subMap(this.allItemStorages, this::canUseForFuel);
        this.fuelItems = fuelMap.isEmpty() ? null : new MountedItemStorageWrapper(fuelMap);
        ImmutableMap fluids = ImmutableMap.copyOf(this.fluidsBuilder);
        this.fluids = new MountedFluidStorageWrapper((ImmutableMap<BlockPos, MountedFluidStorage>)fluids);
        this.fluidsBuilder = null;
        this.syncedItems = ImmutableMap.copyOf(this.syncedItemsBuilder);
        this.syncedItemsBuilder = null;
        this.syncedFluids = ImmutableMap.copyOf(this.syncedFluidsBuilder);
        this.syncedFluidsBuilder = null;
    }

    private boolean isExposed(MountedItemStorage storage) {
        return !AllTags.AllMountedItemStorageTypeTags.INTERNAL.matches(storage);
    }

    private boolean canUseForFuel(MountedItemStorage storage) {
        return this.isExposed(storage) && !AllTags.AllMountedItemStorageTypeTags.FUEL_BLACKLIST.matches(storage);
    }

    private boolean isInitialized() {
        return this.itemsBuilder == null;
    }

    private void assertInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("MountedStorageManager is uninitialized");
        }
    }

    protected void reset() {
        this.allItemStorages = null;
        this.items = null;
        this.fuelItems = null;
        this.fluids = null;
        this.externalHandlers = new ArrayList<IItemHandlerModifiable>();
        this.allItems = null;
        this.itemsBuilder = new HashMap<BlockPos, MountedItemStorage>();
        this.fluidsBuilder = new HashMap<BlockPos, MountedFluidStorage>();
        this.syncedItemsBuilder = new HashMap<BlockPos, SyncedMountedStorage>();
        this.syncedFluidsBuilder = new HashMap<BlockPos, SyncedMountedStorage>();
    }

    public void addBlock(Level level, BlockState state, BlockPos globalPos, BlockPos localPos, @Nullable BlockEntity be) {
        Object storage;
        MountedFluidStorageType<?> fluidType;
        Object storage2;
        MountedItemStorageType<?> itemType = MountedItemStorageType.REGISTRY.get(state.m_60734_());
        if (itemType != null && (storage2 = itemType.mount(level, state, globalPos, be)) != null) {
            this.addStorage((MountedItemStorage)storage2, localPos);
        }
        if ((fluidType = MountedFluidStorageType.REGISTRY.get(state.m_60734_())) != null && (storage = fluidType.mount(level, state, globalPos, be)) != null) {
            this.addStorage((MountedFluidStorage)storage, localPos);
        }
    }

    public void unmount(Level level, StructureTemplate.StructureBlockInfo info, BlockPos globalPos, @Nullable BlockEntity be) {
        MountedFluidStorageType<?> expectedType;
        MountedFluidStorage fluidStorage;
        MountedItemStorageType<?> expectedType2;
        BlockPos localPos = info.f_74675_();
        BlockState state = info.f_74676_();
        MountedItemStorage itemStorage = (MountedItemStorage)this.getAllItemStorages().get((Object)localPos);
        if (itemStorage != null && itemStorage.type == (expectedType2 = MountedItemStorageType.REGISTRY.get(state.m_60734_()))) {
            itemStorage.unmount(level, state, globalPos, be);
        }
        if ((fluidStorage = (MountedFluidStorage)this.getFluids().storages.get((Object)localPos)) != null && fluidStorage.type == (expectedType = MountedFluidStorageType.REGISTRY.get(state.m_60734_()))) {
            fluidStorage.unmount(level, state, globalPos, be);
        }
    }

    public void tick(AbstractContraptionEntity entity) {
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            return;
        }
        HashMap<BlockPos, MountedItemStorage> items = new HashMap<BlockPos, MountedItemStorage>();
        HashMap<BlockPos, MountedFluidStorage> fluids = new HashMap<BlockPos, MountedFluidStorage>();
        this.syncedItems.forEach((pos, storage) -> {
            if (storage.isDirty()) {
                items.put((BlockPos)pos, (MountedItemStorage)((Object)storage));
                storage.markClean();
            }
        });
        this.syncedFluids.forEach((pos, storage) -> {
            if (storage.isDirty()) {
                fluids.put((BlockPos)pos, (MountedFluidStorage)((Object)storage));
                storage.markClean();
            }
        });
        if (!items.isEmpty() || !fluids.isEmpty()) {
            MountedStorageSyncPacket packet = new MountedStorageSyncPacket(entity.m_19879_(), items, fluids);
            AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)packet);
            this.syncCooldown = 8;
        }
    }

    public void handleSync(MountedStorageSyncPacket packet, AbstractContraptionEntity entity) {
        ImmutableMap<BlockPos, MountedItemStorage> items = this.getAllItemStorages();
        MountedFluidStorageWrapper fluids = this.getFluids();
        this.reset();
        IdentityHashMap<SyncedMountedStorage, BlockPos> syncedStorages = new IdentityHashMap<SyncedMountedStorage, BlockPos>();
        try {
            this.itemsBuilder.putAll((Map<BlockPos, MountedItemStorage>)items);
            this.fluidsBuilder.putAll((Map<BlockPos, MountedFluidStorage>)fluids.storages);
            packet.items.forEach((pos, storage) -> {
                this.itemsBuilder.put((BlockPos)pos, (MountedItemStorage)storage);
                syncedStorages.put((SyncedMountedStorage)((Object)storage), (BlockPos)pos);
            });
            packet.fluids.forEach((pos, storage) -> {
                this.fluidsBuilder.put((BlockPos)pos, (MountedFluidStorage)storage);
                syncedStorages.put((SyncedMountedStorage)((Object)storage), (BlockPos)pos);
            });
        }
        catch (Throwable t) {
            Create.LOGGER.error("An error occurred while syncing a MountedStorageManager", t);
        }
        this.initialize();
        Contraption contraption = entity.getContraption();
        syncedStorages.forEach((storage, pos) -> storage.afterSync(contraption, (BlockPos)pos));
    }

    public void read(CompoundTag nbt, boolean clientPacket, @Nullable Contraption contraption) {
        this.reset();
        try {
            NBTHelper.iterateCompoundList((ListTag)nbt.m_128437_("items", 10), tag -> {
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos"));
                CompoundTag data = tag.m_128469_("storage");
                MountedItemStorage.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)data).resultOrPartial(err -> Create.LOGGER.error("Failed to deserialize mounted item storage: {}", err)).map(Pair::getFirst).ifPresent(storage -> this.addStorage((MountedItemStorage)storage, pos));
            });
            NBTHelper.iterateCompoundList((ListTag)nbt.m_128437_("fluids", 10), tag -> {
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos"));
                CompoundTag data = tag.m_128469_("storage");
                MountedFluidStorage.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)data).resultOrPartial(err -> Create.LOGGER.error("Failed to deserialize mounted fluid storage: {}", err)).map(Pair::getFirst).ifPresent(storage -> this.addStorage((MountedFluidStorage)storage, pos));
            });
            this.readLegacy(nbt);
            if (nbt.m_128441_("interactable_positions")) {
                this.interactablePositions = new HashSet<BlockPos>();
                NBTHelper.iterateCompoundList((ListTag)nbt.m_128437_("interactable_positions", 10), tag -> {
                    BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag);
                    this.interactablePositions.add(pos);
                });
            }
        }
        catch (Throwable t) {
            Create.LOGGER.error("Error deserializing mounted storage", t);
        }
        this.initialize();
        if (!clientPacket || contraption == null) {
            return;
        }
        this.getAllItemStorages().forEach((pos, storage) -> {
            if (storage instanceof SyncedMountedStorage) {
                SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
                synced.afterSync(contraption, (BlockPos)pos);
            }
        });
        this.getFluids().storages.forEach((pos, storage) -> {
            if (storage instanceof SyncedMountedStorage) {
                SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
                synced.afterSync(contraption, (BlockPos)pos);
            }
        });
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        ListTag items = new ListTag();
        this.getAllItemStorages().forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                MountedItemStorage.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, storage).resultOrPartial(err -> Create.LOGGER.error("Failed to serialize mounted item storage: {}", err)).ifPresent(encoded -> {
                    CompoundTag tag = new CompoundTag();
                    tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                    tag.m_128365_("storage", encoded);
                    items.add((Object)tag);
                });
            }
        });
        if (!items.isEmpty()) {
            nbt.m_128365_("items", (Tag)items);
        }
        ListTag fluids = new ListTag();
        this.getFluids().storages.forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                MountedFluidStorage.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, storage).resultOrPartial(err -> Create.LOGGER.error("Failed to serialize mounted fluid storage: {}", err)).ifPresent(encoded -> {
                    CompoundTag tag = new CompoundTag();
                    tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                    tag.m_128365_("storage", encoded);
                    fluids.add((Object)tag);
                });
            }
        });
        if (!fluids.isEmpty()) {
            nbt.m_128365_("fluids", (Tag)fluids);
        }
        if (clientPacket) {
            Sets.SetView positions = Sets.union((Set)this.getAllItemStorages().keySet(), (Set)this.getFluids().storages.keySet());
            ListTag list = new ListTag();
            for (BlockPos pos2 : positions) {
                list.add((Object)NbtUtils.m_129224_((BlockPos)pos2));
            }
            nbt.m_128365_("interactable_positions", (Tag)list);
        }
    }

    public void attachExternal(IItemHandlerModifiable externalStorage) {
        this.externalHandlers.add(externalStorage);
        IItemHandlerModifiable[] all = new IItemHandlerModifiable[this.externalHandlers.size() + 1];
        all[0] = this.items;
        for (int i = 0; i < this.externalHandlers.size(); ++i) {
            all[i + 1] = this.externalHandlers.get(i);
        }
        this.allItems = new CombinedInvWrapper(all);
    }

    public CombinedInvWrapper getAllItems() {
        this.assertInitialized();
        return this.allItems;
    }

    public ImmutableMap<BlockPos, MountedItemStorage> getAllItemStorages() {
        this.assertInitialized();
        return this.allItemStorages;
    }

    public MountedItemStorageWrapper getMountedItems() {
        this.assertInitialized();
        return this.items;
    }

    @Nullable
    public MountedItemStorageWrapper getFuelItems() {
        this.assertInitialized();
        return this.fuelItems;
    }

    public MountedFluidStorageWrapper getFluids() {
        this.assertInitialized();
        return this.fluids;
    }

    public boolean handlePlayerStorageInteraction(Contraption contraption, Player player, BlockPos localPos) {
        if (!(player instanceof ServerPlayer)) {
            return this.interactablePositions != null && this.interactablePositions.contains(localPos);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(localPos);
        if (info == null) {
            return false;
        }
        MountedStorageManager storageManager = contraption.getStorage();
        MountedItemStorage storage = (MountedItemStorage)storageManager.getAllItemStorages().get((Object)localPos);
        if (storage != null) {
            return storage.handleInteraction(serverPlayer, contraption, info);
        }
        return false;
    }

    private void readLegacy(CompoundTag nbt) {
        NBTHelper.iterateCompoundList((ListTag)nbt.m_128437_("Storage", 10), tag -> {
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Pos"));
            CompoundTag data = tag.m_128469_("Data");
            if (data.m_128441_("Toolbox")) {
                this.addStorage(ToolboxMountedStorage.fromLegacy(data), pos);
            } else if (data.m_128441_("NoFuel")) {
                this.addStorage(ItemVaultMountedStorage.fromLegacy(data), pos);
            } else if (data.m_128441_("Bottomless")) {
                ItemStack supplied = ItemStack.m_41712_((CompoundTag)data.m_128469_("ProvidedStack"));
                this.addStorage(new CreativeCrateMountedStorage(supplied), pos);
            } else if (data.m_128441_("Synced")) {
                this.addStorage(DepotMountedStorage.fromLegacy(data), pos);
            } else {
                ItemStackHandler handler = new ItemStackHandler();
                handler.deserializeNBT(data);
                this.addStorage(new FallbackMountedStorage((IItemHandler)handler), pos);
            }
        });
        NBTHelper.iterateCompoundList((ListTag)nbt.m_128437_("FluidStorage", 10), tag -> {
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Pos"));
            CompoundTag data = tag.m_128469_("Data");
            if (data.m_128441_("Bottomless")) {
                this.addStorage(CreativeFluidTankMountedStorage.fromLegacy(data), pos);
            } else {
                this.addStorage(FluidTankMountedStorage.fromLegacy(data), pos);
            }
        });
    }

    private void addStorage(MountedItemStorage storage, BlockPos pos) {
        this.itemsBuilder.put(pos, storage);
        if (storage instanceof SyncedMountedStorage) {
            SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
            this.syncedItemsBuilder.put(pos, synced);
        }
    }

    private void addStorage(MountedFluidStorage storage, BlockPos pos) {
        this.fluidsBuilder.put(pos, storage);
        if (storage instanceof SyncedMountedStorage) {
            SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
            this.syncedFluidsBuilder.put(pos, synced);
        }
    }

    private static <K, V> ImmutableMap<K, V> subMap(Map<K, V> map, Predicate<V> predicate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((key, value) -> {
            if (predicate.test(value)) {
                builder.put(key, value);
            }
        });
        return builder.build();
    }
}

