/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.filter;

import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.voice.api.client.audio.filter.AudioFilter;
import su.plo.voice.api.client.audio.filter.AudioFilterContext;
import su.plo.voice.api.util.AudioUtil;
import su.plo.voice.api.util.CircularBuffer;

public final class GainFilter
implements AudioFilter {
    private final DoubleConfigEntry entry;
    private float volume;
    private final CircularBuffer<Float> highestValues = new CircularBuffer<Float>(48, Float.valueOf(-1.0f));

    @Override
    @NotNull
    public String getName() {
        return "gain";
    }

    @Override
    public short[] process(@NotNull AudioFilterContext context, short[] samples) {
        this.volume = ((Double)this.entry.value()).floatValue();
        short highestValue = AudioUtil.getHighestAbsoluteSample(samples);
        float highestPossibleMultiplier = 32766.0f / (float)highestValue;
        if (this.volume > highestPossibleMultiplier) {
            this.volume = highestPossibleMultiplier;
        }
        this.highestValues.put(Float.valueOf(this.volume));
        float minVolume = -1.0f;
        for (float highest : this.highestValues.getCollection()) {
            if (highest < 0.0f) continue;
            if (minVolume < 0.0f) {
                minVolume = highest;
                continue;
            }
            minVolume = Math.min(minVolume, highest);
        }
        this.volume = Math.min(minVolume, this.volume);
        for (int i = 0; i < samples.length; ++i) {
            samples[i] = (short)((float)samples[i] * this.volume);
        }
        return samples;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public GainFilter(DoubleConfigEntry entry) {
        this.entry = entry;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }
}

