/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.libs.adventure.adventure.text;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.libs.adventure.adventure.text.BuildableComponent;
import su.plo.slib.libs.adventure.adventure.text.Component;
import su.plo.slib.libs.adventure.adventure.text.ComponentBuilder;
import su.plo.slib.libs.adventure.adventure.text.ComponentLike;
import su.plo.slib.libs.adventure.adventure.text.ScopedComponent;
import su.plo.slib.libs.adventure.adventure.text.TranslationArgument;
import su.plo.slib.libs.adventure.adventure.translation.Translatable;
import su.plo.slib.libs.adventure.examination.ExaminableProperty;

public interface TranslatableComponent
extends BuildableComponent<TranslatableComponent, Builder>,
ScopedComponent<TranslatableComponent> {
    @NotNull
    public String key();

    @Contract(pure=true)
    @NotNull
    default public TranslatableComponent key(@NotNull Translatable translatable) {
        return this.key(Objects.requireNonNull(translatable, "translatable").translationKey());
    }

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent key(@NotNull String var1);

    @Deprecated
    @NotNull
    public List<Component> args();

    @Deprecated
    @Contract(pure=true)
    @NotNull
    default public TranslatableComponent args(ComponentLike ... args2) {
        return this.arguments(args2);
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    default public TranslatableComponent args(@NotNull List<? extends ComponentLike> args2) {
        return this.arguments(args2);
    }

    @NotNull
    public List<TranslationArgument> arguments();

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent arguments(ComponentLike ... var1);

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent arguments(@NotNull List<? extends ComponentLike> var1);

    @Nullable
    public String fallback();

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent fallback(@Nullable String var1);

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.concat(Stream.of(ExaminableProperty.of("key", this.key()), ExaminableProperty.of("arguments", this.arguments()), ExaminableProperty.of("fallback", this.fallback())), BuildableComponent.super.examinableProperties());
    }

    public static interface Builder
    extends ComponentBuilder<TranslatableComponent, Builder> {
        @Contract(pure=true)
        @NotNull
        default public Builder key(@NotNull Translatable translatable) {
            return this.key(Objects.requireNonNull(translatable, "translatable").translationKey());
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder key(@NotNull String var1);

        @Deprecated
        @Contract(value="_ -> this")
        @NotNull
        default public Builder args(@NotNull ComponentBuilder<?, ?> arg) {
            return this.arguments(arg);
        }

        @Deprecated
        @Contract(value="_ -> this")
        @NotNull
        default public Builder args(ComponentBuilder<?, ?> ... args2) {
            return this.arguments(args2);
        }

        @Deprecated
        @Contract(value="_ -> this")
        @NotNull
        default public Builder args(@NotNull Component arg) {
            return this.arguments(arg);
        }

        @Deprecated
        @Contract(value="_ -> this")
        @NotNull
        default public Builder args(ComponentLike ... args2) {
            return this.arguments(args2);
        }

        @Deprecated
        @Contract(value="_ -> this")
        @NotNull
        default public Builder args(@NotNull List<? extends ComponentLike> args2) {
            return this.arguments(args2);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder arguments(ComponentLike ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder arguments(@NotNull List<? extends ComponentLike> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder fallback(@Nullable String var1);
    }
}

